# Observation Summary Table - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Conformance**](conformance.md)
* [**Must Support**](must-support.md)
* **Observation Summary Table**

## Observation Summary Table

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

This table compares **Must Support** Elements across all the US Core Observation Profiles.

* **Profile Name**: [head-occipital-frontal-circumference-percentile](StructureDefinition-head-occipital-frontal-circumference-percentile.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [8289-1](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8289-1)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [pediatric-bmi-for-age](StructureDefinition-pediatric-bmi-for-age.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [59576-9](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-59576-9)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [pediatric-weight-for-height](StructureDefinition-pediatric-weight-for-height.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [77606-2](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-77606-2)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-average-blood-pressure](StructureDefinition-us-core-average-blood-pressure.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [96607-7](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-96607-7)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: 
* **Profile Name**:   systolic
  * **Category**: 
  * **Code**: [96608-5](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-96608-5)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**:   diastolic
  * **Category**: 
  * **Code**: [96609-3](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-96609-3)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**: [us-core-blood-pressure](StructureDefinition-us-core-blood-pressure.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [85354-9](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-85354-9)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**:   systolic
  * **Category**: 
  * **Code**: [8480-6](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8480-6)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**:   diastolic
  * **Category**: 
  * **Code**: [8462-4](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8462-4)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**: [us-core-bmi](StructureDefinition-us-core-bmi.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [39156-5](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-39156-5)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-body-height](StructureDefinition-us-core-body-height.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [8302-2](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8302-2)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-body-temperature](StructureDefinition-us-core-body-temperature.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [8310-5](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8310-5)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-body-weight](StructureDefinition-us-core-body-weight.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [29463-7](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-29463-7)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-care-experience-preference](StructureDefinition-us-core-care-experience-preference.md)
  * **Category**: [care-experience-preference](CodeSystem-us-core-category.md#us-core-category-care-experience-preference)
  * **Code**: [95541-9](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-95541-9)
  * **Time Types**: S(all)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-head-circumference](StructureDefinition-us-core-head-circumference.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [9843-4](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-9843-4)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-heart-rate](StructureDefinition-us-core-heart-rate.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [8867-4](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-8867-4)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-observation-adi-documentation](StructureDefinition-us-core-observation-adi-documentation.md)
  * **Category**: [observation-adi-documentation](CodeSystem-us-core-category.md#us-core-category-observation-adi-documentation)
  * **Code**: [45473-6](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-45473-6)
  * **Time Types**: (all)
  * **Value Types**: S[CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept)
* **Profile Name**: [us-core-observation-lab](StructureDefinition-us-core-observation-lab.md)
  * **Category**: [laboratory](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-laboratory)
  * **Code**: [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)VS[US Core Laboratory Test Codes](ValueSet-us-core-laboratory-test-codes.md)
  * **Time Types**: S(all)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-observation-occupation](StructureDefinition-us-core-observation-occupation.md)
  * **Category**: [social-history](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-social-history)
  * **Code**: [11341-5](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-11341-5)
  * **Time Types**: (all)
  * **Value Types**: [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept)
* **Profile Name**:   industry
  * **Category**: 
  * **Code**: [86188-0](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-86188-0)
  * **Time Types**: 
  * **Value Types**: S[CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept)
* **Profile Name**: [us-core-observation-pregnancyintent](StructureDefinition-us-core-observation-pregnancyintent.md)
  * **Category**: [social-history](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-social-history)
  * **Code**: [86645-9](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-86645-9)
  * **Time Types**: [dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)
  * **Value Types**: [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept)
* **Profile Name**: [us-core-observation-pregnancystatus](StructureDefinition-us-core-observation-pregnancystatus.md)
  * **Category**: [social-history](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-social-history)
  * **Code**: [82810-3](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-82810-3)
  * **Time Types**: [dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)
  * **Value Types**: [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept)
* **Profile Name**: [us-core-observation-screening-assessment](StructureDefinition-us-core-observation-screening-assessment.md)
  * **Category**: [survey](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-survey)
  * **Code**: [preferred](http://hl7.org/fhir/R4/terminologies.html#preferred)VS[Screening and Assessment Survey Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.13/expansion)
  * **Time Types**: S(all)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-observation-sexual-orientation](StructureDefinition-us-core-observation-sexual-orientation.md)
  * **Category**: 
  * **Code**: [76690-7](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-76690-7)
  * **Time Types**: S(all)
  * **Value Types**: (all)
* **Profile Name**: [us-core-pulse-oximetry](StructureDefinition-us-core-pulse-oximetry.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)VS[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**:   FlowRate
  * **Category**: 
  * **Code**: [3151-8](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-3151-8)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**:   Concentration
  * **Category**: 
  * **Code**: [3150-0](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-3150-0)
  * **Time Types**: 
  * **Value Types**: S[Quantity](http://hl7.org/fhir/R4/datatypes.html#Quantity)
* **Profile Name**: [us-core-respiratory-rate](StructureDefinition-us-core-respiratory-rate.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [9279-1](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-9279-1)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-smokingstatus](StructureDefinition-us-core-smokingstatus.md)
  * **Category**: [social-history](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-social-history)
  * **Code**: [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)VS[Smoking Status Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.6/expansion)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-treatment-intervention-preference](StructureDefinition-us-core-treatment-intervention-preference.md)
  * **Category**: [treatment-intervention-preference](CodeSystem-us-core-category.md#us-core-category-treatment-intervention-preference)
  * **Code**: [75773-2](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html#v3-loinc-75773-2)
  * **Time Types**: S(all)
  * **Value Types**: S(all)
* **Profile Name**: [us-core-vital-signs](StructureDefinition-us-core-vital-signs.md)
  * **Category**: [vital-signs](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html#observation-category-vital-signs)
  * **Code**: [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)VS[Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion)
  * **Time Types**: S[dateTime](http://hl7.org/fhir/R4/datatypes.html#dateTime)|[Period](http://hl7.org/fhir/R4/datatypes.html#Period)
  * **Value Types**: S(all)

This table is also available as an [Excel](observations-summary.xlsx) file.

