# Examples - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following examples are published in this guide, and all are available as downloadable zip files [here](downloads.md#examples). Another source of examples that conform to this guide is the synthetic patient data generated by [Synthea](https://github.com/synthetichealth/synthea) TM in the FHIR R4 format.

These examples show what data produced and consumed by systems conforming with this implementation guide might look like. Every effort has been made to ensure that the examples are correct and useful, but they are not a normative part of the specification, nor fully representative of real-world examples.

### AllergyIntolerance

* [AllergyIntolerance Example](AllergyIntolerance-example.md)
* [AllergyIntolerance Non-pharmacologic Agent Example](AllergyIntolerance-non-pharmacologic-agent-example.md)

### Bundle

* [AllergyIntolerance Provenance Example 1](Bundle-allergyintolerance-provenance-example1.md)
* [AllergyIntolerance Provenance Example 2](Bundle-allergyintolerance-provenance-example2.md)
* [Docref Example 1](Bundle-docref-example-1.md)
* [Docref Example 2](Bundle-docref-example-2.md)
* [PractitionerRole_Practitioner_Endpoint_Bundle_Example Example](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md)

### CarePlan

* [Colonoscopy Example](CarePlan-colonoscopy.md)

### CareTeam

* [CareTeam Example](CareTeam-example.md)
* [Missing Coded Data Example](CareTeam-missing-coded-data-example.md)

### Condition

* [Condition Duodenal Ulcer Example](Condition-condition-duodenal-ulcer.md)
* [Encounter Diagnosis Example 1](Condition-encounter-diagnosis-example1.md)
* [Encounter Diagnosis Example 2](Condition-encounter-diagnosis-example2.md)
* [Health Concern Example](Condition-health-concern-example.md)
* [SDOH Problem/Health Concern Example](Condition-condition-SDOH-example.md)

### Coverage

* [Coverage Example](Coverage-coverage-example.md)

### Device

* [Device Defib Example](Device-udi-2.md)
* [Device Knee Example](Device-udi-3.md)
* [UDI 1 Example](Device-udi-1.md)

### DiagnosticReport

* [Basic Metabolic Panel Example](DiagnosticReport-metabolic-panel.md)
* [CBC Example](DiagnosticReport-cbc.md)
* [DiagnosticReport Cardiology Report Example](DiagnosticReport-cardiology-report.md)
* [DiagnosticReport Chest Xray Report Example](DiagnosticReport-chest-xray-report.md)
* [DXA Bone density quantitative measurement panel Example](DiagnosticReport-bone-density-report.md)

### DocumentReference

* [Discharge Summary Example](DocumentReference-discharge-summary.md)
* [DocumentReference DNR](DocumentReference-adi-dnr.md)
* [DocumentReference Living Will](DocumentReference-living-will.md)
* [DocumentReference POLST (PDF)](DocumentReference-polst.md)
* [Episode Summary Example](DocumentReference-episode-summary.md)

### Encounter

* [Encounter 1 Example](Encounter-example-1.md)
* [Encounter 1036 Example](Encounter-1036.md)
* [Encounter Delivery Example](Encounter-delivery.md)

### Goal

* [Goal 1 Example](Goal-goal-1.md)
* [Goal 2 Example](Goal-goal-sdoh-2.md)

### Immunization

* [Immunization Example 1](Immunization-imm-1.md)

### Library

* [US Core Version 3.1.1 Model Definition](Library-uscore-3.1.1-model-definition.md)
* [US Core Version 4.0.0 Model Definition](Library-uscore-4.0.0-model-definition.md)
* [US Core Version 5.0.1 Model Definition](Library-uscore-5.0.1-model-definition.md)
* [US Core Version 6.1.0 Model Definition](Library-uscore-6.1.0-model-definition.md)
* [US Core Version 7.0.0 Model Definition](Library-uscore-7.0.0-model-definition.md)
* [US Core Version 8.0.1 Model Definition](Library-uscore-8.0.1-model-definition.md)

### Location

* [HL7East Example](Location-hl7east.md)
* [Hospital Location](Location-hospital.md)

### Media

* [Chest Xray Example](Media-chest-xray.md)
* [EKG Strip Image](Media-ekg-strip.md)

### Medication

* [Uscore Med1 Example](Medication-uscore-med1.md)
* [Uscore Med2 Example](Medication-uscore-med2.md)

### MedicationDispense

* [Medication Dispense Example](MedicationDispense-medicationdispense-example.md)

### MedicationRequest

* [MedicationRequest Coded Oral Axid Example](MedicationRequest-medicationrequest-coded-oral-axid.md)
* [MedicationRequest Contained Oral Axid Example](MedicationRequest-medicationrequest-contained-oral-axid.md)
* [MedicationRequest Referenced Oral Axid Example](MedicationRequest-medicationrequest-referenced-oral-axid.md)
* [MedicationRequest Self Tylenol Example](MedicationRequest-self-tylenol.md)

### Observation

* [10 minute Apgar Color Example](Observation-10-minute-apgar-color.md)
* [10 minute Apgar Heart Rate Example](Observation-10-minute-apgar-heart-rate.md)
* [10 minute Apgar Muscle Tone Example](Observation-10-minute-apgar-muscle-tone.md)
* [10 minute Apgar Reflex Irritability Example](Observation-10-minute-apgar-reflex-irritability.md)
* [10 minute Apgar Respiratory effort Example](Observation-10-minute-apgar-respiratory-effort.md)
* [10 Minute Apgar Score Example](Observation-10-minute-apgar-score.md)
* [10 Minute Apgar Score Panel Example](Observation-10-minute-apgar-score-panel.md)
* [ADI Observation Presence ADI Example](Observation-ADI-example.md)
* [ADI Observation Presence No ADI Example](Observation-no-ADI-example.md)
* [Ahc-Hrsn Item Observation Example 68517-2](Observation-AHC-HRSN-item-example-68517-2.md)
* [Alcohol Use Status Example](Observation-alcohol-use-status.md)
* [Alcoholic Drinks Per Day Example](Observation-alcoholic-drinks-per-day.md)
* [At Home In Vitro Test Example](Observation-at-home-in-vitro-test.md)
* [Audit-C Item Example 68517-2](Observation-AUDIT-C-item-example-68517-2.md)
* [Audit-C Item Example 68519-8](Observation-AUDIT-C-item-example-68519-8.md)
* [Audit-C Item Example 68520-6](Observation-AUDIT-C-item-example-68520-6.md)
* [Audit-C Item Example 75626-2](Observation-AUDIT-C-item-example-75626-2.md)
* [Audit-C Panel Example 72109-2](Observation-AUDIT-C-panel-example-72109-2.md)
* [Average Blood Pressure Example](Observation-average-blood-pressure.md)
* [Blood Pressure Example](Observation-blood-pressure.md)
* [BMI Example](Observation-bmi.md)
* [BP Data Absent Example](Observation-bp-data-absent.md)
* [Capillary refill Time Nail Bed Example](Observation-capillary-refill-time-nail-bed.md)
* [Care Experience Preference Example](Observation-care-experience-preference.md)
* [Cigarette Pack-Years Example](Observation-pack-years-example.md)
* [DXA Femur-L ArMass BMD Example](Observation-dxa-femur-l-armass-bmd.md)
* [DXA Femur-L T-score BMD Example](Observation-dxa-femur-l-t-score-bmd.md)
* [DXA Femur-L Z-score BMD Example](Observation-dxa-femur-l-z-score-bmd.md)
* [DXA Hip-L ArMass BMD Example](Observation-dxa-hip-l-armass-bmd.md)
* [DXA Hip-L T-score BMD Example](Observation-dxa-hip-l-t-score-bmd.md)
* [DXA Hip-L Z-score BMD Example](Observation-dxa-hip-l-z-score-bmd.md)
* [EKG impression Example](Observation-ekg-impression.md)
* [EKG lead Example](Observation-ekg-lead.md)
* [Erythrocytes Example](Observation-cbc-erythrocytes.md)
* [Evs Item Example 68516-4](Observation-EVS-item-example-68516-4.md)
* [Evs Item Example 89555-7](Observation-EVS-item-example-89555-7.md)
* [Evs Panel Example 89574-8](Observation-EVS-panel-example-89574-8.md)
* [Exercise Per Day Example](Observation-exercise-per-day.md)
* [Exercise Per Week Example](Observation-exercise-per-week.md)
* [Head Circumference Example](Observation-head-circumference.md)
* [Heart Rate Example](Observation-heart-rate.md)
* [Heart rate rhythm Example](Observation-heart-rate-rhythm.md)
* [Height Example](Observation-height.md)
* [Hematocrit Example](Observation-cbc-hematocrit.md)
* [Hemoglobin Example](Observation-cbc-hemoglobin.md)
* [HVS Item Example 88122-7](Observation-HVS-item-example-88122-7.md)
* [HVS Item Example 88123-5](Observation-HVS-item-example-88123-5.md)
* [HVS Item Example 88124-3](Observation-HVS-item-example-88124-3.md)
* [HVSPanel Example 88121-9](Observation-HVS-panel-example-88121-9.md)
* [Jugular vein distension Example](Observation-jugular-vein-distension.md)
* [Length Example](Observation-length.md)
* [Leukocytes Example](Observation-cbc-leukocytes.md)
* [MCH Example](Observation-cbc-mch.md)
* [MCHC Example](Observation-cbc-mchc.md)
* [MCV Example](Observation-cbc-mcv.md)
* [Observation SatO2 FiO2 Example](Observation-satO2-fiO2.md)
* [Occupation Observation Example](Observation-observation-occupation.md)
* [Occupation Observation Example: Industry Unknown](Observation-observation-occupation-industry-unknown.md)
* [Occupation Observation Example: Unknown Occupation](Observation-observation-occupation-unknown.md)
* [OFC Percentile Example](Observation-ofc-percentile.md)
* [Oxygen Saturation Example](Observation-oxygen-saturation.md)
* [P-R interval {EKG lead} Example](Observation-p-r-interval-ekg-lead.md)
* [Pediatric BMI Example](Observation-pediatric-bmi-example.md)
* [Pediatric Wt Example](Observation-pediatric-wt-example.md)
* [PHQ9 Item Example 44250-9](Observation-PHQ9-item-example-44250-9.md)
* [PHQ9 Item Example 44251-7](Observation-PHQ9-item-example-44251-7.md)
* [PHQ9 Item Example 44252-5](Observation-PHQ9-item-example-44252-5.md)
* [PHQ9 Item Example 44253-3](Observation-PHQ9-item-example-44253-3.md)
* [PHQ9 Item Example 44254-1](Observation-PHQ9-item-example-44254-1.md)
* [PHQ9 Item Example 44255-8](Observation-PHQ9-item-example-44255-8.md)
* [PHQ9 Item Example 44258-2](Observation-PHQ9-item-example-44258-2.md)
* [PHQ9 Item Example 44259-0](Observation-PHQ9-item-example-44259-0.md)
* [PHQ9 Item Example 44260-8](Observation-PHQ9-item-example-44260-8.md)
* [PHQ9 Item Example 44261-6](Observation-PHQ9-item-example-44261-6.md)
* [PHQ9 Item Example 69722-7](Observation-PHQ9-item-example-69722-7.md)
* [PHQ9 Panel Example 44249-1](Observation-PHQ9-panel-example-44249-1.md)
* [Platelets Example](Observation-cbc-platelets.md)
* [Prapare Item Example 54899-0](Observation-PRAPARE-item-example-54899-0.md)
* [Prapare Item Example 56051-6](Observation-PRAPARE-item-example-56051-6.md)
* [Prapare Item Example 56799-0](Observation-PRAPARE-item-example-56799-0.md)
* [Prapare Item Example 63512-8](Observation-PRAPARE-item-example-63512-8.md)
* [Prapare Item Example 63586-2](Observation-PRAPARE-item-example-63586-2.md)
* [Prapare Item Example 67875-5](Observation-PRAPARE-item-example-67875-5.md)
* [Prapare Item Example 71802-3](Observation-PRAPARE-item-example-71802-3.md)
* [Prapare Item Example 76437-3](Observation-PRAPARE-item-example-76437-3.md)
* [Prapare Item Example 76501-6](Observation-PRAPARE-item-example-76501-6.md)
* [Prapare Item Example 82589-3](Observation-PRAPARE-item-example-82589-3.md)
* [Prapare Item Example 93026-3](Observation-PRAPARE-item-example-93026-3.md)
* [Prapare Item Example 93027-1](Observation-PRAPARE-item-example-93027-1.md)
* [Prapare Item Example 93028-9](Observation-PRAPARE-item-example-93028-9.md)
* [Prapare Item Example 93029-7](Observation-PRAPARE-item-example-93029-7.md)
* [Prapare Item Example 93030-5](Observation-PRAPARE-item-example-93030-5.md)
* [Prapare Item Example 93033-9](Observation-PRAPARE-item-example-93033-9.md)
* [Prapare Item Example 93034-7](Observation-PRAPARE-item-example-93034-7.md)
* [Prapare Item Example 93035-4](Observation-PRAPARE-item-example-93035-4.md)
* [Prapare Item Example 93038-8](Observation-PRAPARE-item-example-93038-8.md)
* [Prapare Multiselect-Item Example 32624-9-Answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md)
* [Prapare Multiselect-Item Example 32624-9-Answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md)
* [Prapare Multiselect-Item Example 93031-3-Answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md)
* [Prapare Multiselect-Item Example 93031-3-Answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md)
* [Prapare Panel Example 93025-5](Observation-PRAPARE-panel-example-93025-5.md)
* [Prapare Panel Example 93039-6](Observation-PRAPARE-panel-example-93039-6.md)
* [Prapare Panel Example 93040-4](Observation-PRAPARE-panel-example-93040-4.md)
* [Prapare Panel Example 93041-2](Observation-PRAPARE-panel-example-93041-2.md)
* [Prapare Panel Example 93042-0](Observation-PRAPARE-panel-example-93042-0.md)
* [PRAPARE Panel Example 93043-8](Observation-PRAPARE-panel-example-93043-8.md)
* [Pregnancy Intent Observation Example](Observation-pregnancy-intent.md)
* [Pregnancy Status Observation Example](Observation-pregnancy-status.md)
* [Pulse intensity Palpation Example](Observation-pulse-intensity-palpation.md)
* [Q-T interval {EKG lead} Example](Observation-q-t-interval-ekg-lead.md)
* [QRS dur {EKG lead} Example](Observation-qrs-dur-ekg-lead.md)
* [Respiratory Rate Example](Observation-respiratory-rate.md)
* [Serum BUN Example](Observation-serum-bun.md)
* [Serum Calcium Example](Observation-serum-calcium.md)
* [Serum Chloride Example](Observation-serum-chloride.md)
* [Serum CO2 Example](Observation-serum-co2.md)
* [Serum Creatinine Example](Observation-serum-creatinine.md)
* [Serum Glucose Example](Observation-serum-glucose.md)
* [Serum Potassium Example](Observation-serum-potassium.md)
* [Serum Sodium Example](Observation-serum-sodium.md)
* [Simple Observation Cognitive Status Example](Observation-simple-observation-cognitive-status.md)
* [Simple Observation Disability Status Example](Observation-simple-observation-disability-status.md)
* [Simple Observation Functional Status Example](Observation-simple-observation-functional-status.md)
* [Simple Observation SDOH Example](Observation-simple-observation-sdoh.md)
* [Some Day Smoker Example](Observation-some-day-smoker.md)
* [Substance Use Status Example](Observation-substance-use-status.md)
* [Taps Item Example 75889-6](Observation-TAPS-item-example-75889-6.md)
* [Taps Item Example 88037-7](Observation-TAPS-item-example-88037-7.md)
* [Taps Item Example 96842-0](Observation-TAPS-item-example-96842-0.md)
* [Taps Item Example 96843-8](Observation-TAPS-item-example-96843-8.md)
* [Taps Item Example 96844-6](Observation-TAPS-item-example-96844-6.md)
* [Taps Panel Example 96841-2](Observation-TAPS-panel-example-96841-2.md)
* [Temperature Example](Observation-temperature.md)
* [Treatment Intervention Preference Example](Observation-treatment-intervention-preference.md)
* [Urobilinogen Example](Observation-urobilinogen.md)
* [Weight Example](Observation-weight.md)
* [Xray Chest Findings Example](Observation-xray-chest-findings.md)
* [Xray Chest Impression Example](Observation-xray-chest-impression.md)

### Organization

* [Organization 2 Example](Organization-example-organization-2.md)
* [Organization Acme Lab Example](Organization-acme-lab.md)
* [Organization Acme Payer Example](Organization-acme-payer.md)
* [Organization Holy Healthcare Example](Organization-holy-healthcare.md)
* [Saint Luke W Endpoint Example](Organization-saint-luke-w-endpoint.md)

### Patient

* [Deceased Patient Example](Patient-deceased-example.md)
* [Patient Child Example](Patient-child-example.md)
* [Patient Example](Patient-example.md)
* [Patient Infant Example](Patient-infant-example.md)

### Practitioner

* [Practitioner 1 Example](Practitioner-practitioner-1.md)
* [Practitioner 2 Example](Practitioner-practitioner-2.md)
* [Practitioner Pharmacist Example](Practitioner-practitioner-pharmacist.md)

### Procedure

* [Procedure Defibrillator Implant Example](Procedure-defib-implant.md)
* [Rehab Example](Procedure-rehab.md)

### Questionnaire

* [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example](Questionnaire-AUDIT-C.md)
* [Exercise Vital Sign Questionnaire Example](Questionnaire-exercise-vital-sign.md)
* [Questionnaire Hunger Vital Sign (HVS) Example](Questionnaire-hunger-vital-sign-example.md)
* [Questionnaire PHQ-9 Example](Questionnaire-phq-9-example.md)
* [Questionnaire PRAPARE Example](Questionnaire-prapare-example.md)
* [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example](Questionnaire-TAPS.md)

### QuestionnaireResponse

* [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md)
* [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md)
* [QuestionnaireResponse Glascow Coma Score Example](QuestionnaireResponse-glascow-coma-score.md)
* [QuestionnaireResponse Hunger Vital Sign (HVS) Example](QuestionnaireResponse-hunger-vital-sign-example.md)
* [QuestionnaireResponse PHQ-9 Example](QuestionnaireResponse-phq-9-example.md)
* [QuestionnaireResponse PRAPARE Example](QuestionnaireResponse-prapare-example.md)
* [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) QuestionnaireResponse Example](QuestionnaireResponse-TAPS.md)

### RelatedPerson

* [Patient Niece Example](RelatedPerson-shaw-niece.md)

### ServiceRequest

* [ServiceRequest BMP Example](ServiceRequest-bmp.md)
* [ServiceRequest CBC Example](ServiceRequest-cbc.md)
* [ServiceRequest Chest XRay Example](ServiceRequest-chest-xray.md)
* [ServiceRequest EKG Example](ServiceRequest-ekg.md)
* [ServiceRequest Food Pantry Referral Example](ServiceRequest-foodpantry-referral.md)
* [ServiceRequest for Rehab Example](ServiceRequest-rehab.md)

### Specimen

* [Lipemic Serum Specimen Example](Specimen-example-serum-lipemic.md)
* [Serum Specimen Example](Specimen-specimen-example-serum.md)
* [Urine Specimen Example](Specimen-specimen-example-urine.md)
* [Whole Blood Specimen Example](Specimen-specimen-example-whole-blood.md)

