# Basic Provenance - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Basic Provenance**

## Basic Provenance

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Provenance in US Core

The FHIR [Provenance](http://hl7.org/fhir/R4/provenance.html) Resource tracks information about the activity about a version of a resource, describing the entities and agents involved. FHIR resources also contain elements that represent "small-p provenance" information about how the resource was obtained which overlap with the functionality of the Provenance resource.

​This page is divided into two section documenting how the [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) records changes at the **organizational level**, and how the US Core Profiles' "small-p provenance" elements record changes at the **individual level**. The US Core Provenance Profile asserts where the data came from at an organizational or system level. Because systems typically do not use the Provenance Resource to represent this information at an **individual level** (in other words, activities by the patient or provider), various FHIR resource elements are identified that track the "small p provenance" information at the individual level. The baseline rules and guidance here do not preclude more advanced use cases such as [Using Provenance To Target Resource Elements](element-level-provenance.md).

### Organizational Level Provenance

The [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) focuses on a key subset of elements, the "last hop", and specific use cases used to assert changes to the record at the organizational level. Full Provenance of a Resource requires details from the original resource creator and all intermediary actors that updated the Resource. Members of the Argonaut community and the HL7 security working group discussed the current sharing approaches and end-user display. They agreed the most important information is the last organization making a meaningful clinical update to the data and the prior system providing it - the 'last hop'. Participants didn't dispute the potential need to recreate the entire chain but didn't see this as relevant to the immediate end-user.

#### Key Provenance Elements

The guidance for Provenance in US Core focuses on six key elements: Timestamp, the Target Resource, Author, Author Organization, Transmitter, and Transmitter Organization. The Timestamp is the date and time the author created, updated, or deleted the data. The Target Resource is the Resource the Provenance record supports. The Author represents the person(s) responsible for the information. The Author Organization defines the organization the author is associated with when they created, updated, or deleted the data. The Transmitter represents the system responsible for transmitting the information. Finally, the Transmitter Organization defines the organization responsible for the transmission.

**Key Provenance elements:**

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Target | Resource Provenancerecord supports |   |   | `Provenance.target` |
| Timestamp | Date |   | Time with timezone offset | `Provenance.recorded` |
| Author |   | NameIdentifier | NPI recommended, additional identifiers allowed | `Provenance.agent.who` |
| Author Organization |   | NameIdentifier | NPI recommended, additional identifiers allowed | `Provenance.agent.onBehalfOf` |
| Transmitter |   | NameIdentifier | NPI recommended, additional identifiers allowed | `Provenance.agent.who` |
| Transmitter Organization |   | NameIdentifier | NPI recommended, additional identifiers allowed | `Provenance.agent.onBehalfOf` |

### Use Cases

The HL7 Basic Provenance Informative implementation guide outlines four use cases: Fax, Health Information Exchange (HIE) redistribution, HIE transformation, and Clinical Information Reconciliation and Incorporation (CIRI). While these use cases may have FHIR implications in the future, CIRI and HIE are the key use cases and are covered in detail here.

#### Clinical Information Reconciliation and Incorporation

[Clinical Information Reconciliation and Incorporation (CIRI)] allows clinicians to reconcile and incorporate patient health information sent in from external sources to maintain a more accurate and up-to-date patient records. Consolidated Clinical Document Architecture (C-CDA) documents are often used to share clinical information with clinicians from external sources like hospitals, Health Information Exchanges (HIEs), or other clinicians, and allows the clinician to import and reconcile health care information into their own patient record. Figure 1 represents information from Good Health and Sunshine Health Organization. Dr. Reconciled reviews the data in Figure 1, updates the reaction to hives, and stores it in the Future Health Organization system. When a mobile app requests the information, it receives Dr. Reconciled as the Author and Future Health as the organization. This type of authorship change is only relevant for data suitable for reconciliation, such as medications, allergies, and problems. If Dr. Accepted had saved other clinical content into his EHR that is not reconciled but stored, such as clinical notes, that content must retain its original author.

The Figure below represents information from two different organizations to a clinician for reconciliation:

**Figure 1: Clinical Information Reconciliation and Incorporation (CIRI) from two Organizations**
![](Provenance_Recon_Workflow_Step2.svg)

Dr. Reconciled is the latest author after updating the reaction on 5/15/2019 and accepting it to the local data store. By accepting the information, Dr. Reconciled is taking over the responsibility.

`GET /AllergyIntolerance?patient=[ID]&_revinclude=Provenance:target`

Good Health Organization Provenance

 Click Here to See 'Get Allergy Information for a Patient at Good Health' Example 

**Request:**

Get “all allergies” for a patient and all corresponding Provenance records.

```
GET [base]/AllergyIntolerance?patient=12345&_revinclude=Provenance:target

```

**Response:**

A Server returns a search Bundle resource containing all the Allergies for the patient and corresponding Provenance records.

```
HTTP/1.1 200 OK
[other headers]

{
"resourceType": "Bundle",
"id": "c887e62f-6166-419f-8268-b5ecd6c7b901",
"meta": {
    "lastUpdated": "2019-07-09T18:49:01.235+00:00"
},
"type": "searchset",
"total": 1,
"link": [
    {
        "relation": "self",
        "url": "http://hapi.fhir.org/baseR4/AllergyIntolerance?patient=Examples&_revinclude=Provenance:target"
    }
],
"entry": [
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/AllergyIntolerance/79613",
        "resource": {
            "resourceType": "AllergyIntolerance",
            "id": "79613",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance"
                ]
            },
            "clinicalStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
                        "code": "active",
                        "display": "Active"
                    }
                ]
            },
            "verificationStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
                        "code": "confirmed",
                        "display": "Confirmed"
                    }
                ]
            },
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "762952008",
                        "display": "Peanuts"
                    }
                ],
                "text": "Peanuts"
            },
            "category": [
                "medication"
            ],
            "criticality": "high",
            "patient": {
                "reference": "Patient/example"
            },
            "onsetDateTime": "2018-01",
            "reaction": [
                {
                    "manifestation": [
                        {
                            "coding": [
                                {
                                    "system": "http://snomed.info/sct",
                                    "code": "247472004",
                                    "display": "Hives"
                                }
                            ]
                        }
                    ],
                    "onset": "2018-01"
                }
            ]
        },
        "search": {
            "mode": "match"
        }
    },
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/Provenance/79614",
        "resource": {
            "resourceType": "Provenance",
            "id": "79614",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance"
                ]
            },
            "target": [
                 {
                    "reference": "AllergyIntolerance/79613"
                }
            ],
         "recorded": "2018-02T15:26:23.217+00:00",
         "agent": [
                {
                    "type": [
                        {
                            "coding": [
                                {
                                    "system": "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                                    "code": "author",
                                    "display": "Author"
                                }
                            ]
                        }
                    ],
                    "who": {
                            "reference": "Practitioner/Dr-Jones-12345"
                    },
                    "onBehalfOf": {
                            "reference": "Organization/good-health-54321"
                    }
                }
            ]},
        "search": {
            "mode": "include"
        }
    }
] }

```

Sunshine Health Organization Provenance

 Click Here to See 'Get Allergy Information for a Patient at Sunshine Health' Example 

**Request:**

Get “all allergies” for a patient and all corresponding Provenance records.

```
GET [base]/AllergyIntolerance?patient=1234599&_revinclude=Provenance:target

```

**Response:**

A Server returns a search Bundle resource containing all the Allergies for the patient and corresponding Provenance records.

```
HTTP/1.1 200 OK
[other headers]

{
"resourceType": "Bundle",
"id": "c887e62f-6166-419f-8268-b5ecd6c7b901",
"meta": {
    "lastUpdated": "2019-07-09T18:49:01.235+00:00"
},
"type": "searchset",
"total": 1,
"link": [
    {
        "relation": "self",
        "url": "http://hapi.fhir.org/baseR4/AllergyIntolerance?patient=Examples99&_revinclude=Provenance:target"
    }
],
"entry": [
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/AllergyIntolerance/7961399",
        "resource": {
            "resourceType": "AllergyIntolerance",
            "id": "7961399",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance"
                ]
            },
            "clinicalStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
                        "code": "active",
                        "display": "Active"
                    }
                ]
            },
            "verificationStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
                        "code": "confirmed",
                        "display": "Confirmed"
                    }
                ]
            },
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "762952008",
                        "display": "Peanuts"
                    }
                ],
                "text": "Peanuts"
            },
            "category": [
                "medication"
            ],
            "criticality": "high",
            "patient": {
                "reference": "Patient/example"
            },
            "onsetDateTime": "2017-09",
            "reaction": [
                {
                    "manifestation": [
                        {
                            "coding": [
                                {
                                    "system": "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                                    "code": "UNK",
                                    "display": "Unknown"
                                }
                            ]
                        }
                    ],
                    "onset": "2017-09"
                }
            ]
        },
        "search": {
            "mode": "match"
        }
    },
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/Provenance/7961499",
        "resource": {
            "resourceType": "Provenance",
            "id": "7961499",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance"
                ]
            },
            "target": [
                 {
                    "reference": "AllergyIntolerance/7961399"
                }
            ],
         "recorded": "2017-09T15:26:23.217+00:00",
         "agent": [
                {
                    "type": [
                        {
                            "coding": [
                                {
                                    "system": "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                                    "code": "author",
                                    "display": "Author"
                                }
                            ]
                        }
                    ],
                    "who": {
                            "reference": "Practitioner/Dr-Smith-1234599"
                    },
                    "onBehalfOf": {
                            "reference": "Organization/sunshine-health-5432199"
                    }
                }
            ]},
        "search": {
            "mode": "include"
        }
    }
] }

```

After reconciliation, the Future Health Organization Provenance contains the latest information.

 Click Here to See 'Get Allergy Information for a Patient at Future Health' Example 

**Request:**

Get “all allergies” for a patient and all corresponding Provenance records.

```
GET [base]/AllergyIntolerance?patient=123459988&_revinclude=Provenance:target

```

**Response:**

A Server returns a search Bundle resource containing all the Allergies for the patient and corresponding Provenance records.

```
HTTP/1.1 200 OK
[other headers]

{
"resourceType": "Bundle",
"id": "94d5d5ac-6645-41dc-8282-1870b71e840a",
"meta": {
    "lastUpdated": "2019-07-20T18:49:01.235+00:00"
},
"type": "searchset",
"total": 1,
"link": [
    {
        "relation": "self",
        "url": "http://hapi.fhir.org/baseR4/AllergyIntolerance?patient=Examples9988&_revinclude=Provenance:target"
    }
],
"entry": [
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/AllergyIntolerance/796139988",
        "resource": {
            "resourceType": "AllergyIntolerance",
            "id": "796139988",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance"
                ]
            },
            "clinicalStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
                        "code": "active",
                        "display": "Active"
                    }
                ]
            },
            "verificationStatus": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
                        "code": "confirmed",
                        "display": "Confirmed"
                    }
                ]
            },
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "762952008",
                        "display": "Peanuts"
                    }
                ],
                "text": "Peanuts"
            },
            "category": [
                "medication"
            ],
            "criticality": "high",
            "patient": {
                "reference": "Patient/example"
            },
            "onsetDateTime": "2017-09",
            "reaction": [
                {
                    "manifestation": [
                        {
                            "coding": [
                                {
                                    "system": "http://snomed.info/sct",
                                    "code": "247472004",
                                    "display": "Hives"
                                }
                            ]
                        }
                    ],
                    "onset": "2017-09"
                }
            ]
        },
        "search": {
            "mode": "match"
        }
    },
    {
        "fullUrl": "http://hapi.fhir.org/baseR4/Provenance/796149988",
        "resource": {
            "resourceType": "Provenance",
            "id": "796149988",
            "meta": {
                "versionId": "1",
                "lastUpdated": "2019-07-09T15:26:23.217+00:00",
                "profile": [
                   "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance"
                ]
            },
            "target": [
                 {
                    "reference": "AllergyIntolerance/796139988"
                }
            ],
         "recorded": "2019-05-15T15:26:23.217+00:00",
         "agent": [
                {
                    "type": [
                        {
                            "coding": [
                                {
                                    "system": "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                                    "code": "author",
                                    "display": "Author"
                                }
                            ]
                        }
                    ],
                    "who": {
                            "reference": "Practitioner/dr-reconciled-123459988"
                    },
                    "onBehalfOf": {
                            "reference": "Organization/future-health-543219988"
                    }
                }
            ]},
        "search": {
            "mode": "include"
        }
    }
] }

```

#### Accepting information from a single site

The Figure below represents information after a provider accepted data from a single site:

**Figure 2: CIRI After Accepting Reconciliation, No Changes**
![](Provenance_Recon_Single_Organization.svg)

Dr. Accepted is the latest author after verifying the problem on 5/2018 and accepting the problem data into their local data store since it went through an interactive reconciliation process.

#### HIE Redistribution

A Health Information Exchange (HIE) is an organization and technology that facilitates information exchange between one and many partners. In specific HIE scenarios, they only redistribute information, while in others, they store, transform, and redistribute information. The HIE must maintain the clinical content fidelity (original author, author organization, and timestamp). In addition, the HIE must keep track of who sent them the information for auditing; however, they are not required to include the original transmitter when redistributing content.

**Figure 3: HIE Redistribution - No clinical content transformation**
![](Provenance_HIE_Single_Org_Device.svg)

Since no clinical content is changed in the HIE redistribution, the best scenario is a Provenance Record with:

* `Provenance.agent.type` = author 
* `Provenance.agent.who` set to the practitioner who authored the content (i.e., not the HIE)
* `Provenance.agent.onBehalfOf` set to the organization that the author acted on behalf of before sharing with the HIE
 
* `Provenance.agent.type` = transmitter 
* `Provenance.agent.who` set to the HIE organization
 

The timestamp and pointer (i.e., target) to the appropriate Resource are required in all cases and must be included. This IG would note these as **SHALL** constraints if systems always had the Author and Author Organizations available. Participants in the development of this guide reported that the Author information provided to HIEs needs to be more consistent and reliable.

#### HIE Transformation

Unlike Use Case 3 - HIE Redistribution, Use Case 4 includes data transformation. Information is received (e.g., v2 lab, other CDs), transformed by a HIE, stored, and passed in a new format (e.g., CCD or FHIR).

**Figure 4: HIE Transformation - Clinical content is transformed**
![](Provenance_HIE_Multi_Org_Device.svg)

Transformation of data from one format to another **MAY** change the authorship of the information, where the HIE is the author/author organization. The HIE must maintain the original data source. An `agent.type`="assembler", `agent.type`="transmitter", or other agents from [Provenance Agent Type](ValueSet-us-core-provenance-participant-type.md) value set **MAY** also be included. Due to insufficient implementer guidance, the Basic Provenance guidance here does not specify how to assign authorship for this use case. HL7 plans to gather additional input and include it in the HL7 Basic Provenance Informative guide for C-CDA and FHIR.

### Individual Level Provenance

The functionality of the Provenance resource discussed above. The table below lists the US Core elements that communicate the author and author roles corresponding to the **[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi)Provenance Author and Author Role Data Elements requirements for individuals**. They are also documented on each US Core Profile page's "Profile Specific Implementation Guidance" section. The author is communicated by the elements and the author's role by the referenced target resource (for example, Patient, Practitioner/PractitionerRole, RelatedPerson, Device). Details about the author's role are contained in the target resource's contents. Many of these elements are labeled [Must Support](must-support.md) or [Additional USCDI Requirements](must-support.md#additional-uscdi-requirements). However, all of these elements and target resources **SHOULD** be supported in the profiles if the system captures the data.

##### Author and Author Role Data Elements

The elements and target resources listed in bold asterisked text indicate that they are **Must Support** or **Additional USCDI Requirements**. The following US Core Profiles were omitted because they are typically not associated with individual authorship:

* US Core CareTeam Profile
* US Core Coverage Profile
* US Core Encounter Profile
* US Core Implantable Device Profile
* US Core Location Profile
* US Core Medication Profile
* US Core Organization Profile
* US Core Patient Profile
* US Core Practitioner Profile
* US Core PractitionerRole Profile
* US Core Provenance Profile
* US Core RelatedPerson Profile
* US Core Specimen Profile

This table is also available as a [csv](tables/provenance-elements.csv) or [excel](tables/provenance-elements.xlsx) file:

| | | |
| :--- | :--- | :--- |
| [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) | `AllergyIntolerance.asserter` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) | `**AllergyIntolerance.recorder***` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md) | `**CarePlan.contributor***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile, Device |
| [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md) | `Condition.asserter` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md) | `**Condition.recorder***` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) | `Condition.asserter` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) | `**Condition.recorder***` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) | `**DiagnosticReport.performer***` | **US Core Practitioner Profile****,**US Core Organization Profile****, US Core PractitionerRole Profile, US Core CareTeam Profile |
| [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) | `DiagnosticReport.resultsInterpreter` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core CareTeam Profile |
| [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) | `**DiagnosticReport.performer***` | **US Core Practitioner Profile****,**US Core Organization Profile****, US Core PractitionerRole Profile, US Core CareTeam Profile |
| [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) | `**DiagnosticReport.resultsInterpreter***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core CareTeam Profile |
| [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md) | `**DocumentReference.author***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile, Device |
| [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) | `**DocumentReference.author***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile, Device |
| [US Core Goal Profile](StructureDefinition-us-core-goal.md) | `**Goal.expressedBy***` | **US Core Practitioner Profile****, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) | `**Immunization.performer.actor***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile, Device |
| [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md) | `**MedicationDispense.performer.actor***` | US Core Practitioner Profile,**US Core Organization Profile****, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device |
| [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) | `**MedicationRequest.requester***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device |
| [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) | `**MedicationRequest.reportedReference***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device |
| [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) | `Observation.device` | Device, DeivceMetric |
| [US Core BMI Profile](StructureDefinition-us-core-bmi.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core BMI Profile](StructureDefinition-us-core-bmi.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Body Height Profile](StructureDefinition-us-core-body-height.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Body Height Profile](StructureDefinition-us-core-body-height.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile,**US Core Patient Profile****, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile,**US Core Patient Profile****, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) | `**Observation.performer***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) | `**Observation.performer***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, US Core CareTeam Profile |
| [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) | `Observation.device` | Device, DeivceMetric |
| [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) | `Procedure.asserter` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) | `**Procedure.performer.actor***` | US Core Practitioner Profile, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device, Device |
| [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | `**QuestionnaireResponse.author***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device, Device |
| [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | `QuestionnaireResponse.source` | US Core Practitioner Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile |
| [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) | `**ServiceRequest.requester***` | **US Core Practitioner Profile****, US Core Organization Profile, US Core PractitionerRole Profile, US Core Patient Profile, US Core RelatedPerson Profile, Device, Device |

* US Core **Must Support** or **Additional USCDI** element

** US Core **Must Support** Target Resource Type

