# Artifacts Summary - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) | This Section describes the expected capabilities of the US Core Client which is responsible for creating and initiating the queries for information about an individual patient. The complete list of FHIR profiles, RESTful operations, and search parameters supported by US Core Servers are defined in the[Conformance Requirements for Server](CapabilityStatement-us-core-server.md). US Core Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |
| [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) | This Section describes the expected capabilities of the US Core Server actor which is responsible for providing responses to the queries submitted by the US Core Requestors. The complete list of FHIR profiles, RESTful operations, and search parameters supported by US Core Servers are defined. Systems implementing this capability statement should meet the ASTP 2015 Common Clinical Data Set (CCDS) access requirement for Patient Selection 170.315(g)(7) and Application Access - Data Category Request 170.315(g)(8) and the ASTP[U.S. Core Data for Interoperability (USCDI) Version 5 July 2024](https://www.healthit.gov/isp/sites/isp/files/2024-07/USCDI-Version-5-July-2024-Final.pdf). |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Core Fetch DocumentReference](OperationDefinition-docref.md) | This operation is used to return all the references to documents related to a patient. It is invoked on a FHIR Server's DocumentReference endpoint (e.g.,`[base]/DocumentReference/$docref`) and operates across all DocumentReference instances.The operation requires a patient id and takes the optional input parameters:* start date
* end date
* document type
* on-demand
* profile
and returns a**searchset**[Bundle](http://hl7.org/fhir/bundle.html)containing[DocumentReference](http://hl7.org/fhir/documentreference.html)resources for the patient. If the server has stored documents or can create documents for the patient and those documents are available for the user, the server returns the DocumentReference resources associated with documents. This operation's intended use is to provide a way for providers or patients to access their available documents. The document itself can be subsequently retrieved using the link provided in the`DocumentReference.content.attachment.url element`. The link could be a FHIR endpoint to a[Binary](http://hl7.org/fhir/R4/binary.html)Resource or some other document repository.This operation is**different**from a FHIR RESTful query on DocumentReference by patient and type and date range because:1. It is used to request a server to**generate**a document based on the specified parameters.
1. If no parameters are specified, the server SHALL return a DocumentReference to the patient's current C-CDA CCD.
1. If the server cannot**generate**a document based on the specified parameters, the operation will return an empty search bundle.
Unless the client indicates they are only interested in 'on-demand' documents using the**on-demand**parameter, the server SHOULD return DocumentReference instances for**existing**documents that meet the request parameters In this regard, this operation is**similar**to a FHIR RESTful query. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [USCoreAllergyintoleranceClinicalStatus](SearchParameter-us-core-allergyintolerance-clinical-status.md) | **active | inactive | resolved**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreAllergyintolerancePatient](SearchParameter-us-core-allergyintolerance-patient.md) | **Who the sensitivity is for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareTeamRole](SearchParameter-us-core-careteam-role.md) | Returns CareTeam resources with a participant role matching the specified code. |
| [USCoreCareplanCategory](SearchParameter-us-core-careplan-category.md) | **Type of plan**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareplanDate](SearchParameter-us-core-careplan-date.md) | **Time period plan covers**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareplanPatient](SearchParameter-us-core-careplan-patient.md) | **Who the care plan is for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareplanStatus](SearchParameter-us-core-careplan-status.md) | **draft | active | on-hold | revoked | completed | entered-in-error | unknown**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareteamPatient](SearchParameter-us-core-careteam-patient.md) | **Who care team is for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCareteamStatus](SearchParameter-us-core-careteam-status.md) | **proposed | active | suspended | inactive | entered-in-error**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionAbatementDate](SearchParameter-us-core-condition-abatement-date.md) | **Date-related abatements (dateTime and period)**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionAssertedDate](SearchParameter-us-core-condition-asserted-date.md) | Returns conditions with an[assertedDate extension](http://hl7.org/fhir/StructureDefinition/condition-assertedDate)matching the specified date (dateTime). |
| [USCoreConditionCategory](SearchParameter-us-core-condition-category.md) | **The category of the condition**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionClinicalStatus](SearchParameter-us-core-condition-clinical-status.md) | **The clinical status of the condition**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionCode](SearchParameter-us-core-condition-code.md) | **Code for the condition**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionEncounter](SearchParameter-us-core-condition-encounter.md) | **Encounter created as part of**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionLastUpdated](SearchParameter-us-core-condition-lastupdated.md) | **When the resource version last changed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionOnsetDate](SearchParameter-us-core-condition-onset-date.md) | **Date related onsets (dateTime and Period)**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionPatient](SearchParameter-us-core-condition-patient.md) | **Who has the condition?**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreConditionRecordedDate](SearchParameter-us-core-condition-recorded-date.md) | **Date record was first recorded**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreCoveragePatient](SearchParameter-us-core-coverage-patient.md) | **Retrieve coverages for a patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDevicePatient](SearchParameter-us-core-device-patient.md) | **Patient information, if the resource is affixed to a person**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDeviceStatus](SearchParameter-us-core-device-status.md) | **active | inactive | entered-in-error | unknown**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDeviceType](SearchParameter-us-core-device-type.md) | **The type of the device**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportCategory](SearchParameter-us-core-diagnosticreport-category.md) | **Which diagnostic discipline/department created the report**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportCode](SearchParameter-us-core-diagnosticreport-code.md) | **The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportDate](SearchParameter-us-core-diagnosticreport-date.md) | **The clinically relevant time of the report**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportLastUpdated](SearchParameter-us-core-diagnosticreport-lastupdated.md) | **When the resource version last changed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportPatient](SearchParameter-us-core-diagnosticreport-patient.md) | **The subject of the report if a patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDiagnosticreportStatus](SearchParameter-us-core-diagnosticreport-status.md) | **The status of the report**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferenceCategory](SearchParameter-us-core-documentreference-category.md) | **Categorization of document**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferenceDate](SearchParameter-us-core-documentreference-date.md) | **When this document reference was created**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferenceId](SearchParameter-us-core-documentreference-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferencePatient](SearchParameter-us-core-documentreference-patient.md) | **Who/what is the subject of the document**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferencePeriod](SearchParameter-us-core-documentreference-period.md) | **Time of service that is being documented**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferenceStatus](SearchParameter-us-core-documentreference-status.md) | **current | superseded | entered-in-error**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreDocumentreferenceType](SearchParameter-us-core-documentreference-type.md) | **Kind of document (LOINC if possible)**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterClass](SearchParameter-us-core-encounter-class.md) | **Classification of patient encounter**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterDate](SearchParameter-us-core-encounter-date.md) | **A date within the period the Encounter lasted**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterDischargeDisposition](SearchParameter-us-core-encounter-discharge-disposition.md) | Returns encounters with an discharge-disposition matching the specified code. |
| [USCoreEncounterId](SearchParameter-us-core-encounter-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterIdentifier](SearchParameter-us-core-encounter-identifier.md) | **Identifier(s) by which this encounter is known**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterLastUpdated](SearchParameter-us-core-encounter-lastupdated.md) | **When the resource version last changed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterLocation](SearchParameter-us-core-encounter-location.md) | **Location the encounter takes place**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterPatient](SearchParameter-us-core-encounter-patient.md) | **The patient or group present at the encounter**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterStatus](SearchParameter-us-core-encounter-status.md) | **planned | arrived | triaged | in-progress | onleave | finished | cancelled +**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEncounterType](SearchParameter-us-core-encounter-type.md) | **Specific type of encounter**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreEthnicity](SearchParameter-us-core-ethnicity.md) | Returns patients with an ethnicity extension matching the specified code. |
| [USCoreGoalDescription](SearchParameter-us-core-goal-description.md) | **The code or text describing the goal****NOTE**: This US Core SearchParameter definition extends the usage context of the[Conformance expectation extension](http://hl7.org/fhir/R4/extension-capabilitystatement-expectation.html)* multipleAnd
* multipleOr
* comparator
* modifier
* chain
 |
| [USCoreGoalLifecycleStatus](SearchParameter-us-core-goal-lifecycle-status.md) | **proposed | planned | accepted | active | on-hold | completed | cancelled | entered-in-error | rejected**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreGoalPatient](SearchParameter-us-core-goal-patient.md) | **Who this goal is intended for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreGoalTargetDate](SearchParameter-us-core-goal-target-date.md) | **Reach goal on or before**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreImmunizationDate](SearchParameter-us-core-immunization-date.md) | **Vaccination (non)-Administration Date**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreImmunizationPatient](SearchParameter-us-core-immunization-patient.md) | **The patient for the vaccination record**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreImmunizationStatus](SearchParameter-us-core-immunization-status.md) | **Immunization event status**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreLocationAddress](SearchParameter-us-core-location-address.md) | **A (part of the) address of the location**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreLocationAddressCity](SearchParameter-us-core-location-address-city.md) | **A city specified in an address**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreLocationAddressPostalcode](SearchParameter-us-core-location-address-postalcode.md) | **A postal code specified in an address**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreLocationAddressState](SearchParameter-us-core-location-address-state.md) | **A state specified in an address**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreLocationName](SearchParameter-us-core-location-name.md) | **A portion of the location's name or alias**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationdispensePatient](SearchParameter-us-core-medicationdispense-patient.md) | **The identity of a patient to list dispenses for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationdispenseStatus](SearchParameter-us-core-medicationdispense-status.md) | **Returns dispenses with a specified dispense status**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationdispenseType](SearchParameter-us-core-medicationdispense-type.md) | **Returns dispenses of a specific type**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationrequestAuthoredon](SearchParameter-us-core-medicationrequest-authoredon.md) | **Return prescriptions written on this date**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationrequestEncounter](SearchParameter-us-core-medicationrequest-encounter.md) | **Return prescriptions with this encounter identifier**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationrequestIntent](SearchParameter-us-core-medicationrequest-intent.md) | **Returns prescriptions with different intents**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationrequestPatient](SearchParameter-us-core-medicationrequest-patient.md) | **Returns prescriptions for a specific patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreMedicationrequestStatus](SearchParameter-us-core-medicationrequest-status.md) | **Status of the prescription**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationCategory](SearchParameter-us-core-observation-category.md) | **The classification of the type of observation**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationCode](SearchParameter-us-core-observation-code.md) | **The code of the observation type**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationDate](SearchParameter-us-core-observation-date.md) | **Obtained date/time. If the obtained element is a period, a date that falls in the period**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationLastUpdated](SearchParameter-us-core-observation-lastupdated.md) | **When the resource version last changed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationPatient](SearchParameter-us-core-observation-patient.md) | **The subject that the observation is about (if patient)**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreObservationStatus](SearchParameter-us-core-observation-status.md) | **The status of the observation**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreOrganizationAddress](SearchParameter-us-core-organization-address.md) | **A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text****NOTE**: This US Core SearchParameter definition extends the usage context of the[Conformance expectation extension](http://hl7.org/fhir/R4/extension-capabilitystatement-expectation.html)* multipleAnd
* multipleOr
* comparator
* modifier
* chain
 |
| [USCoreOrganizationName](SearchParameter-us-core-organization-name.md) | **A portion of the organization's name or alias****NOTE**: This US Core SearchParameter definition extends the usage context of the[Conformance expectation extension](http://hl7.org/fhir/R4/extension-capabilitystatement-expectation.html)* multipleAnd
* multipleOr
* comparator
* modifier
* chain
 |
| [USCorePatientBirthdate](SearchParameter-us-core-patient-birthdate.md) | **The patient's date of birth**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientDeathDate](SearchParameter-us-core-patient-death-date.md) | **The date of death has been provided and satisfies this search value**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientFamily](SearchParameter-us-core-patient-family.md) | **A portion of the family name of the patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientGiven](SearchParameter-us-core-patient-given.md) | **A portion of the given name of the patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientId](SearchParameter-us-core-patient-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientIdentifier](SearchParameter-us-core-patient-identifier.md) | **A patient identifier**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePatientName](SearchParameter-us-core-patient-name.md) | **A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePractitionerId](SearchParameter-us-core-practitioner-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePractitionerIdentifier](SearchParameter-us-core-practitioner-identifier.md) | **A practitioner's Identifier**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePractitionerName](SearchParameter-us-core-practitioner-name.md) | **A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePractitionerrolePractitioner](SearchParameter-us-core-practitionerrole-practitioner.md) | **Practitioner that is able to provide the defined services for the organization**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCorePractitionerroleSpecialty](SearchParameter-us-core-practitionerrole-specialty.md) | **The practitioner has this specialty at an organization**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreProcedureCode](SearchParameter-us-core-procedure-code.md) | **A code to identify a procedure**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreProcedureDate](SearchParameter-us-core-procedure-date.md) | **When the procedure was performed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreProcedurePatient](SearchParameter-us-core-procedure-patient.md) | **Search by subject - a patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreProcedureStatus](SearchParameter-us-core-procedure-status.md) | **preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreQuestionnaireresponseAuthored](SearchParameter-us-core-questionnaireresponse-authored.md) | **When the questionnaire response was last changed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreQuestionnaireresponseId](SearchParameter-us-core-questionnaireresponse-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreQuestionnaireresponsePatient](SearchParameter-us-core-questionnaireresponse-patient.md) | **The patient that is the subject of the questionnaire response**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreQuestionnaireresponseQuestionnaire](SearchParameter-us-core-questionnaireresponse-questionnaire.md) | **The questionnaire the answers are provided for**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreQuestionnaireresponseStatus](SearchParameter-us-core-questionnaireresponse-status.md) | **The status of the questionnaire response**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreRace](SearchParameter-us-core-race.md) | Returns patients with a race extension matching the specified code. |
| [USCoreRelatedpersonId](SearchParameter-us-core-relatedperson-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreRelatedpersonName](SearchParameter-us-core-relatedperson-name.md) | **A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreRelatedpersonPatient](SearchParameter-us-core-relatedperson-patient.md) | **The patient this related person is related to**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestAuthored](SearchParameter-us-core-servicerequest-authored.md) | **Date request signed**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestCategory](SearchParameter-us-core-servicerequest-category.md) | **Classification of service**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestCode](SearchParameter-us-core-servicerequest-code.md) | **What is being requested/ordered**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestId](SearchParameter-us-core-servicerequest-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestPatient](SearchParameter-us-core-servicerequest-patient.md) | **Search by subject - a patient**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreServicerequestStatus](SearchParameter-us-core-servicerequest-status.md) | **draft | active | on-hold | revoked | completed | entered-in-error | unknown**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreSpecimenId](SearchParameter-us-core-specimen-id.md) | **Logical id of this artifact**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |
| [USCoreSpecimenPatient](SearchParameter-us-core-specimen-patient.md) | **The patient the specimen comes from**NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements:* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md) | The US Core Advance Directive Information (ADI) DocumentReference Profile inherits from the FHIR[DocumentReference](https://hl7.org/fhir/R4/documentreference.html)resource; refer to it for scope and usage definitions. This profile and the[US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md)meet the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Advance Directive Observation**Data Element requirements. It sets minimum expectations for searching and fetching patient Advance Directive Information (ADI) documents using the DocumentReference resource. Examples of advance healthcare directive documents include physician order for life sustaining treatment (POLST), do not resuscitate order (DNR), and medical power of attorney. In addition to the document contents, it communicates the type of advance directive document, the author, the verifier, and other properties. To represent whether advance directive documents exist for a patient, see the US Core Observation ADI Documentation Profile. This profile sets minimum expectations for searching and fetching patient ADI documents using the DocumentReference resource. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) | The US Core AllergyIntolerance Profile inherits from the FHIR[AllergyIntolerance](https://hl7.org/fhir/R4/allergyintolerance.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the AllergyIntolerance resource to record, search, and fetch allergies/adverse reactions associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md) | The US Core Average Blood Pressure Profile inherits from the[Observation](https://hl7.org/fobservation.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for recording, searching, and fetching average diastolic and systolic blood pressure observations with standard LOINC codes and UCUM units of measure. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core BMI Profile](StructureDefinition-us-core-bmi.md) | The US Core BMI Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch Body Mass Index (BMI) observations with a standard LOINC codes and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) | US Core Blood Pressure Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch diastolic and systolic blood pressure observations with standard LOINC codes and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Body Height Profile](StructureDefinition-us-core-body-height.md) | The US Core Body Height Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md) | The US Core Body Temperature Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch body temperature observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md) | The US Core Body Weight Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch body weight observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md) | The US Core Care Experience Preference Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to This profile provides guidance on how to record a care experience preference expressed by the patient regarding their care and treatment. Examples include, but are not limited to, religious preferences, dislikes and fears, preferred place for birth, preferred pharmacy, and thoughts and feelings to be shared. This profile does not represent an actual order, but it can guide caregivers and medical personnel about what is important for the person. This profile sets minimum expectations for the Observation resource to record, search, and fetch for a patient care experience preferences. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md) | The US Core CarePlan Profile inherits from the FHIR[CarePlan](https://hl7.org/fhir/R4/careplan.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the CarePlan resource to record, search, and fetch assessment and plan of treatment data associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md) | The US Core CareTeam Profile inherits from the FHIR[CareTeam](https://hl7.org/fhir/R4/careteam.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the CareTeam resource for identifying the Care Team members associated with a patient to promote interoperability and adoption through common implementation. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md) | The US Core Condition Encounter Diagnosis Profile inherits from the FHIR[Condition](https://hl7.org/fhir/R4/condition.html)resource; refer to it for scope and usage definitions. US Core version 5.0.0 split the US Core Condition Profile into this profile and the US Core Condition Problems and Health Concerns Profile. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Encounter Diagnosis**Data Element. It sets minimum expectations for the Condition resource to record, search, and fetch information about an encounter diagnosis. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) | The US Core Condition Problems and Health Concerns Profile inherits from the FHIR[Condition](https://hl7.org/fhir/R4/condition.html)resource; refer to it for scope and usage definitions. US Core version 5.0.0 split the US Core Condition Profile into this profile and the US Core Condition Encounter Diagnosis Profile. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Problems**,**Health Concerns**, and**SDOH Problems/Health Concerns**Data Elements. It sets minimum expectations for the Condition resource to record, search, and fetch information about a condition, diagnosis, or another event, situation, issue, or clinical concept documented and categorized as a problem or health concern, including information about a Social Determinants of Health related condition. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) | The US Core Coverage Profile inherits from the FHIR[Coverage](https://hl7.org/fhir/R4/coverage.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the US Core Data for Interoperability (USCDI)**Health Insurance Information**Data Class. It sets minimum expectations for the Coverage resource to record, search, and fetch data related to an individual's insurance coverage for health care. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) | The US Core DiagnosticReport Profile for Laboratory Results Reporting inherits from the FHIR[DiagnosticReport](https://hl7.org/fhir/R4/diagnosticreport.html)resource; refer to it for scope and usage definitions. Laboratory results are grouped and summarized using the DiagnosticReport resource, which typically references Observation resource(s). Each Observation resource represents an individual laboratory test and result value or component result values or a nested panel (such as a microbial susceptibility panel) that references other observations. Laboratory results can also be presented in report form or as free text. This profile sets minimum expectations for the DiagnosticReport resource to record, search, and fetch laboratory results associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) | The US Core DiagnosticReport Profile for Report and Note Exchange inherits from the FHIR[DiagnosticReport](https://hl7.org/fhir/R4/diagnosticreport.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching Diagnostic Reports and Notes using the DiagnosticReport resource. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile. |
| [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) | The US Core DocumentReference Profile inherits from the FHIR[DocumentReference](https://hl7.org/fhir/R4/documentreference.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching patient documents including Clinical Notes using the DocumentReference resource. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile. |
| [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) | The US Core Encounter Profile inherits from the FHIR[Encounter](https://hl7.org/fhir/R4/encounter.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Encounter resource to record, search, and fetch basic encounter information for an individual patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Goal Profile](StructureDefinition-us-core-goal.md) | The US Core Goal Profile inherits from the FHIR[Goal](https://hl7.org/fhir/R4/goal.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Goal resource to record, search, and fetch Goal information associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Head Circumference Profile](StructureDefinition-us-core-head-circumference.md) | The US Core Head Circumference Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch head circumference observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md) | The US Core Heart Rate Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch heart rate observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) | The US Core Immunization Profile inherits from the FHIR[Immunization](https://hl7.org/fhir/R4/immunization.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Immunization resource to record, search, and fetch immunization history associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md) | The US Core Device Profile inherits from the FHIR[Device](https://hl7.org/fhir/R4/device.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Unique Device Identifier - Implantable**Data Element. It sets minimum expectations for the Device resource to record, search, and fetch UDI information associated with a patient's implantable device(s). It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) | The US Core Laboratory Result Observation Profile is based upon the US Core Observation Clinical Result Profile and, along with the US Core DiagnosticReport Profile for Laboratory Results Reporting, meets the U.S. Core Data for Interoperability (USCDI) Laboratory requirements. Laboratory results are grouped and summarized using the DiagnosticReport resource, which references Observation resources. Each Observation resource represents an individual laboratory test and result value, a “nested” panel (such as a microbial susceptibility panel) that references other observations, or rarely a laboratory test with component result values. The US Core Laboratory Result Observation Profile sets minimum expectations for the Observation resource to record, search, and fetch laboratory test results associated with a patient to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets SHALL be present in the resource and constrains the way the elements are used when using this profile. It provides the floor for standards development for specific use cases. |
| [US Core Location Profile](StructureDefinition-us-core-location.md) | The US Core Location Profile inherits from the FHIR[Location](https://hl7.org/fhir/R4/location.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Location resource for recording, searching, and fetching a "physical place of available services or resources." It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Medication Profile](StructureDefinition-us-core-medication.md) | The US Core Medication Profile inherits from the FHIR[Medication](https://hl7.org/fhir/R4/medication.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Medication resource to record, search, and fetch medications associated with a patient. When referencing a medication, the MedicationRequest resource can use a code or refer to this profile. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md) | The US Core MedicationDispense Profile inherits from the FHIR[MedicationDispense](https://hl7.org/fhir/R4/medicationdispense.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the MedicationDispense resource to record, search, and fetch the state of a patients medication with regards to dispensing or other activity. (e.g., dispensed, partially dispensed, not dispensed) It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) | The US Core MedicationRequest Profile inherits from the FHIR[MedicationRequest](https://hl7.org/fhir/R4/medicationrequest.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Medications**Data Class. This profile sets minimum expectations for the MedicationRequest resource to record, search, and fetch a patient's medication prescriptions or orders. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md) | The US Core Observation Advance Directive Information (ADI) Documentation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile and the[US Core Observation ADI DocumentationReference Profile](StructureDefinition-us-core-adi-documentreference.md)meet the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Advance Directive Observation**Data Element requirements. It is used to communicate whether a person has advance directive information (ADI) and, if one or more documents exist, their location. Examples of advance healthcare directive documents include physician order for life sustaining treatment (POLST), do not resuscitate order (DNR), and medical power of attorney. To communicate the type of advance directive document, the author, the verifier, and other properties, see the US Core ADI DocumentReference Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch findings about the presence of a patient's advance directives. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md) | The US Core Observation Clinical Result Profile is based upon the core FHIR Observation Resource and, along with the US Core DiagnosticReport Profile, meets the US Core Data for Interoperability (USCDI) requirements for**Diagnostic Imaging**and**Clinical Tests**Data Classes. This profile sets minimum expectations for the Observation resource to record and search non-laboratory clinical test results (e.g., radiology and other clinical observations generated from procedures). An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy. This profile is the basis for the US Core Laboratory Result Observation Profile, which defines additional data elements to record and search laboratory test results.The US Core Observation Clinical Result Profile sets minimum expectations to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains the way the elements are used when using this profile. It provides the floor for standards development for specific use cases. |
| [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) | The US Core Observation Occupation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Occupation**and**Occupation Industry**Data Elements. It sets minimum expectations for the Observation resource to record, search, and fetch a patient's past or present job as occupation and industry, in other words, the type of work and type of business that compensates for work or assigns work to an unpaid worker or volunteer. In the context of this profile, a job is defined as a work situation or a training or volunteer position held for a specified period. This profile specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md) | The US Core Observation Pregnancy Intent Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Pregnancy Status**Data Element. This profile sets minimum expectations for the Observation resource to record, search, and fetch the patient's intention to become pregnant. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md) | The US Core Pregnancy Status Observation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Pregnancy Status**Data Element. It sets minimum expectations for the Observation resource to record, search, and fetch the patient's state or condition of being pregnant. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) | The US Core Observation Screening Assessment Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. Beginning with US Core Version 6.0.0, this profile supersedes the US Core Observation Survey Profile (see the[Changes Between Versions](changes-between-versions.md)page for a summary of cross-version comparisons of US Core Profiles). This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Health Status Assessments**Data Class. It sets the minimum expectations for the Observation Resource to record, search, and fetch observations representing the questions and responses to surveys and screening and assessment tools. For example, a social history status such as education or food insecurity or an assessment of cognitive, functional, or disability status. It can represent a single response, multiple responses, and multi-select "check all that apply" type questions. This profile specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Screening and Assessments guidance page, which documents the process of recording responses and capturing assertions/determinations resulting from surveys and questionnaires. |
| [US Core Observation Sexual Orientation Profile](StructureDefinition-us-core-observation-sexual-orientation.md) | The US Core Observation Sexual Orientation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to refer to it for scope and usage definitions. This Profile sets minimum expectations for the Observation resource to record, search, and fetch sexual orientation observations associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Organization Profile](StructureDefinition-us-core-organization.md) | The US Core Organization Profile inherits from the FHIR[Organization](https://hl7.org/fhir/R4/organization.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Organization resource to record, search, and fetch patient or provider organziation information. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Patient Profile](StructureDefinition-us-core-patient.md) | The US Core Patient Profile inherits from the FHIR[Patient](https://hl7.org/fhir/R4/patient.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the[U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi)**Patient Demographics/Information**Data Class. It sets minimum expectations for the Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md) | The US Core Pediatric BMI for Age Observation Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch pediatric body mass index (BMI) percentile per age and sex for youth 2-20 observations in FHIR using a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md) | The US Core Pediatric Head Occipital Frontal Circumference Percentile Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch pediatric head occipital frontal circumference (OFC) percentile observations associated with a patient from birth to 37 Months of age using a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md) | US Core Pediatric Weight for Height Observation Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch pediatric weight-for-length per age and sex observations in FHIR with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md) | The US Core Practitioner Profile inherits from the FHIR[Practitioner](https://hl7.org/fhir/R4/practitioner.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Practitioner resource to record, search, and fetch basic demographics and administrative information about an individual practitioner. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md) | The US Core PractitionerRole Profile inherits from the FHIR[PractitionerRole](https://hl7.org/fhir/R4/practitionerrole.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the PractitionerRole Resource to record, search, and fetch the practitioner role information. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. The requirements for the US Core Practitioner were drawn from the[Argonaut Provider Directory](http://www.fhir.org/guides/argonaut/pd//release1/index.html),[IHE Healthcare Provider Directory](http://ihe.net/uploadedFiles/Documents/ITI/IHE_ITI_Suppl_HPD.pdf)and the[ONC Provider Directory Workshop](https://confluence.oncprojectracking.org/display/PDW/Workshop+Documents). |
| [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) | The US Core Procedure Profile inherits from the FHIR[Procedure](https://hl7.org/fhir/R4/procedure.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Procedures**Data Class. It sets minimum expectations for the Procedure resource to record, search, and fetch procedure information associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) | The US Core Provenance Profile inherits from the FHIR[Provenance](https://hl7.org/fhir/R4/provenance.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Provenance resource to record, search, and fetch provenance information associated with a record. It covers the minimal (basic) information to support lineage of information. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Before reviewing this profile, implementers are encouraged to read the Basic Provenance guidance page, which documents several key use cases, specifically, the organization responsible for the most recent action on the resource. |
| [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) | The US Core Pulse Oximetry Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and pulse oximetry and inspired oxygen observations with standard LOINC codes and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | The US Core QuestionaireResponse Profile inherits from the[Structured Data Capture (SDC) Questionnaire Response Profile](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaireresponse.html). This profile sets minimum expectations for the QuestionnaireResponse resource to record, search, and fetch retrieve captures the responses to form/survey and assessment tools such as the**Protocol for Responding to and Assessing Patients\u2019 Assets, Risks, and Experiences (PRAPARE) Survey**. It specifies which core**additional**elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Before reviewing this profile, implementers are encouraged to read the Screening and Assessments guidance page, which documents the process of recording responses and capturing assertions/determinations resulting from surveys and questionnaires. |
| [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) | The US Core RelatedPerson Profile inherits from the FHIR[RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the RelatedPerson resource to record, search, and fetch basic administrative information about persons with a legal or familial relationship to a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md) | The US Core Respiratory Rate Profile inherits from the US Core Vital Signs Profile. This profile sets minimum expectations for the Observation resource to record, search, and fetch respiratory rate observations with a standard LOINC code and UCUM units of measure. It specifies which**additional**core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) | The US Core ServiceRequest Profile inherits from the FHIR[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for recording, searching, and fetching the ServiceRequest information. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md) | The US Core Simple Observation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This US Core FHIR Profile captures any "simple" observations not covered by other US Core Observation profiles. It represents any observation not classified as vital signs, laboratory, imaging, or other specific observation types. This profile sets minimum expectations for the Observation resource to record, search, and retrieve observations such as a clinical observation or assertion about patient health status or other general observations. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) | The US Core Smoking Status Observation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Smoking Status**Data Element. This profile sets minimum expectations for the Observation resource to record, search, and fetch smoking status data associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Specimen Profile](StructureDefinition-us-core-specimen.md) | The US Core Specimen Profile inherits from the FHIR[Specimen](https://hl7.org/fhir/R4/specimen.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Specimen resource to record, search, and fetch information about substances associated with a patient being sampled or tested (such as nasopharyngeal swab, whole blood, or serum). It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md) | The US Core Treatment Intervention Preference Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to it for scope and usage definitions. This profile provides guidance on how to record a treatment intervention preference expressed by the patient regarding their personal health goals, preferences, and priorities for medical treatments or interventions in the event of a future health scenario where a person is unable to make medical decisions because of a severe illness or injury. This profile does not represent an actual order, but it can guide caregivers and medical personnel about what is important for the person. This profile sets minimum expectations for the Observation resource to record, search, and fetch for patient treatment intervention preferences. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. |
| [US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md) | This profile is based on the base[FHIR Vital Signs Profile](http://hl7.org/fhir/R4/observation-vitalsigns.html)and defines**additional**constraints on the Observation resource to represent vital signs observations. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. This US Core profiles that are derived from this profile are listed below. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Core Authentication Time Extension](StructureDefinition-us-core-authentication-time.md) | This extension indicates when the information in the document was verified. |
| [US Core Birth Sex Extension](StructureDefinition-us-core-birthsex.md) | A code classifying the person's sex assigned at birth. This extension aligns with LOINC 76689-9 (Sex assigned at birth). |
| [US Core Direct email Extension](StructureDefinition-us-core-direct.md) | This email address is associated with a["Direct Secure Messaging"](https://directtrust.org/what-we-do/direct-secure-messaging)service. This extension can only be used on contact points where the system = 'email' |
| [US Core Ethnicity Extension](StructureDefinition-us-core-ethnicity.md) | Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality. The ethnicity codes used to represent these concepts are based upon the[Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238)which includes over 900 concepts for representing race and ethnicity of which 43 reference ethnicity. The ethnicity concepts are grouped by and pre-mapped to the 2 OMB ethnicity categories:* Hispanic or Latino
* Not Hispanic or Latino.
 |
| [US Core Extension Questionnaire URI](StructureDefinition-us-core-extension-questionnaire-uri.md) | The location where a non-FHIR questionnaire/survey form can be found. This extension is used when the survey, form, or questionnaire which is being answered is not a FHIR[Questionnaire](https://www.hl7.org/fhir/questionnaire.html), otherwise the[canonical url](https://www.hl7.org/fhir/references.html#canonical)for the FHIR Questionnaire is used. |
| [US Core Gender Identity Extension](StructureDefinition-us-core-genderIdentity.md) | This extension represents an individual's sense of being a man, woman, boy, girl, nonbinary, or something else, ascertained by asking them what that identity is. |
| [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) | USCDI includes a data element for Sex, intended to support the exchange of a recorded sex value. This extension aligns with the USCDI definition of Sex: "Documentation of a specific instance of sex." It enables systems to share the sex value as it was documented in a particular context. Systems choosing to record sources of information should use the[Provenance resource](element-level-provenance.md). |
| [US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md) | This extension indicates the individual's need for an interpreter to communicate healthcare information in a language other than the default language of the organization. It has the same meaning as the LOINC[54588-9](https://loinc.org/54588-9)(Interpreter needed) |
| [US Core Jurisdiction Extension](StructureDefinition-us-core-jurisdiction.md) | An extension to communicate the US state or local jurisdiction for individual and entity identifiers. For example, a practitioner's state or local jurisdiction for a license. |
| [US Core Medication Adherence Extension](StructureDefinition-us-core-medication-adherence.md) | The Medication Adherence Extension is used to report whether a medication has been consumed according to instructions as reported by a patient or on behalf of the patient. |
| [US Core Race Extension](StructureDefinition-us-core-race.md) | Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality. The race codes used to represent these concepts are based upon the[Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238)which includes over 900 concepts for representing race and ethnicity of which 921 reference race. The race concepts are grouped by and pre-mapped to the 5 OMB race categories:* American Indian or Alaska Native
* Asian
* Black or African American
* Native Hawaiian or Other Pacific Islander
* White.
 |
| [US Core Sex Extension](StructureDefinition-us-core-sex.md) | The Sex Extension is used to reflect the documentation of a person's sex. Systems choosing to record sources of information should use the[Provenance resource](element-level-provenance.md).USCDI includes a data element for sex, intended to support the exchange of a sex value that is not characterized as sex assigned at birth or birth sex. This Sex extension supports USCDI. Sex assigned at birth or birth sex can be recorded using the more specific[US Core Birth Sex Extension](StructureDefinition-us-core-birthsex.md). Future versions of this extension may be informed by the content of the HL7 Cross Paradigm IG: Gender Harmony - Sex and Gender Representation, which may include additional guidance on its relationship to administrative gender ([Patient.gender](StructureDefinition-us-core-patient-definitions.md#Patient.gender)). |
| [US Core Tribal Affiliation Extension](StructureDefinition-us-core-tribal-affiliation.md) | This Extension profile represents a tribe or band with which a person associates and, optionally, whether they are enrolled. |
| [US Core USCDI Requirement Extension](StructureDefinition-uscdi-requirement.md) | **This extension is only used in the US Core Implementation Guide''s Profile StructureDefinition elements.**It flags elements that are**Additional**USCDI Requirements for certified systems. In other words, elements that are not marked as Must Support but are required for ASTP Health IT certification testing. See the[Conformance page](general-requirements.md)for more information. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Core Clinical Note Type](ValueSet-us-core-clinical-note-type.md) | The US Core Clinical Note Type Value Set is a 'starter set' of types supported for fetching and storing clinical notes. |
| [US Core Clinical Result Observation Category](ValueSet-us-core-clinical-result-observation-category.md) | Used to classify the context of clinical result observations. |
| [US Core Condition Codes](ValueSet-us-core-condition-code.md) | This describes the problem. Diagnosis/Problem List is broadly defined as a series of brief statements that catalog a patient's medical, nursing, dental, social, preventative and psychiatric events and issues that are relevant to that patient's healthcare (e.g., signs, symptoms, and defined conditions). ICD-10 is appropriate for Diagnosis information, and ICD-9 for historical information. |
| [US Core Condition Codes Current](ValueSet-us-core-condition-code-current.md) | This valueset is defined the same as the[US Core Condition Codes](ValueSet-us-core-condition-code.md)value set except it excludes ICD-9-CM codes. It us used for encoding newly recorded, non-legacy problem list items, health concerns and diagnosis using SNOMED CT and ICD-10-CM per USCDI requirements. |
| [US Core Diagnostic Report Category Codes](ValueSet-us-core-diagnosticreport-category.md) | The US Core Diagnostic Report Category Value Set is a 'starter set' of categories supported for fetching and Diagnostic Reports and notes. |
| [US Core DocumentReference Category](ValueSet-us-core-documentreference-category.md) | The US Core DocumentReferences Category Value Set is a 'starter set' of categories supported for fetching and storing clinical notes. |
| [US Core DocumentReference Type](ValueSet-us-core-documentreference-type.md) | The US Core DocumentReference Type Value Set includes all LOINC values whose SCALE is "Doc" in the LOINC database and the HL7 v3 Code System NullFlavor concept 'unknown' |
| [US Core Goal Codes](ValueSet-us-core-goal-description.md) | Concepts from SNOMED CT and LOINC code systems that can be used to indicate the goal. |
| [US Core Laboratory Test Codes](ValueSet-us-core-laboratory-test-codes.md) | Laboratory LOINC codes: From the introduction to August 2022 LOINC Users' guide; "The current scope of the existing laboratory portion of the LOINC database includes all observations reported by clinical laboratories, including the specialty areas: chemistry, including therapeutic drug monitoring and toxicology; hematology; serology; blood bank; microbiology; cytology; surgical pathology; and fertility. |
| [US Core Narrative Status](ValueSet-us-core-narrative-status.md) | The US Core Narrative Status Value Set limits the text status for the resource narrative. |
| [US Core Non Laboratory Codes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md) | This value set includes All LOINC codes defined as type "clinical," therefore excluding laboratory tests, survey instruments, and claims documents. This includes observables such as vital signs, hemodynamics, intake/output, EKG, obstetric ultrasound, and cardiac echo, and includes discrete and narrative diagnostic observations and reports. |
| [US Core Problem or Health Concern](ValueSet-us-core-problem-or-health-concern.md) | Code set for category codes for**US Core Condition Problems and Health Concerns Profile**consisting of the concepts "problem" and "health-concern". |
| [US Core Procedure Codes](ValueSet-us-core-procedure-code.md) | Concepts from CPT, SNOMED CT, HCPCS Level II Alphanumeric Codes, ICD-10-PCS,CDT and LOINC code systems that can be used to indicate the type of procedure performed. |
| [US Core Provenance Participant Type Codes](ValueSet-us-core-provenance-participant-type.md) | The type of participation a provenance agent played for a given target. |
| [US Core Screening Assessment Condition Category](ValueSet-us-core-screening-assessment-condition-category.md) | This value set consists of the single code "sdoh". It is the minimum value set of category codes used in the US Core Condition Problems and Health Concerns Profile that any conformant system**SHALL**support to help identify the type of USCDI Health Status/Assessment data class being reported. |
| [US Core Screening Assessment Observation Category](ValueSet-us-core-screening-assessment-observation-category.md) | This value set is the minimum value set of category codes used in the US Core Observation Screening Assessment and Simple Observation Profiles that any conformant system**SHALL**support to help identify the type of USCDI Health Status/Assessment data class being reported. |
| [US Core Screening Assessment Observation Maximum Category](ValueSet-us-core-screening-assessment-observation-maximum-category.md) | This value set is a value set of category codes used in the US Core Observation Screening Assessment that any conformant system**SHOULD**support to help identify the type of USCDI Health Status/Assessment data class being reported. |
| [US Core ServiceRequest Category Codes](ValueSet-us-core-servicerequest-category.md) | A set of SNOMED CT and LOINC concepts to classify a requested service |
| [US Core Simple Observation Category](ValueSet-us-core-simple-observation-category.md) | This value set is a value set of category codes used in the US Core Simple Observation and Condition Problems and Health Concerns Profiles that any conformant system**SHOULD**support to help identify the type of USCDI Health Status/Assessment data class being reported. |
| [US Core Specimen Condition](ValueSet-us-core-specimen-condition.md) | This value set contains concepts the provide information regarding a specimen, including the container, that does not meet a laboratory’s criteria for acceptability. |
| [US Core Status for Smoking Status Observation](ValueSet-us-core-observation-smoking-status-status.md) | Codes providing the status of an observation for smoking status. Constrained to`final`and`entered-in-error`. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Core CarePlan Category Extension Codes](CodeSystem-careplan-category.md) | Set of codes that are needed for implementation of the US-Core CarePlan Profile. These codes are used as extensions to the FHIR ValueSet. |
| [US Core Category](CodeSystem-us-core-category.md) | Category codes used across US Core Profiles and resource types. They are typically used when there is a need for categorization for searching and finding resources or workflow hints. |
| [US Core Condition Category Extension Codes](CodeSystem-condition-category.md) | Set of codes that are needed for implementation of the US-Core Condition Profile. These codes are used as extensions to the FHIR and US Core value sets. |
| [US Core DocumentReferences Category Codes](CodeSystem-us-core-documentreference-category.md) | The US Core DocumentReferences Type Code System is a 'starter set' of categories supported for fetching and storing DocumentReference Resources. |
| [US Core Provenance Participant Type Extension Codes](CodeSystem-us-core-provenance-participant-type.md) | Set of codes that are needed for implementation of the US-Core Provenance Profile. These codes are used as extensions to the FHIR value sets. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [10 Minute Apgar Score Example](Observation-10-minute-apgar-score.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse. |
| [10 Minute Apgar Score Panel Example](Observation-10-minute-apgar-score-panel.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture surveys assessments as a panel of observations. It is not derived from a FHIR QuestionnaireResponse. |
| [10 minute Apgar Color Example](Observation-10-minute-apgar-color.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse. |
| [10 minute Apgar Heart Rate Example](Observation-10-minute-apgar-heart-rate.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse. |
| [10 minute Apgar Muscle Tone Example](Observation-10-minute-apgar-muscle-tone.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse. |
| [10 minute Apgar Reflex Irritability Example](Observation-10-minute-apgar-reflex-irritability.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse.. |
| [10 minute Apgar Respiratory effort Example](Observation-10-minute-apgar-respiratory-effort.md) | This example of a US Core Survey Observation Profile illustrates its use to directly capture individual surveys assessment items as an observations. It is not derived from a FHIR QuestionnaireResponse. |
| [ADI Observation Presence ADI Example](Observation-ADI-example.md) | This is a Observation example for the USCDI5 ADI Observation Data Element to show whether and location of a patient has an advance directive using code 45473-6 (Advance healthcare directive completed) and a SNOMED CT value of "Yes" with Supporting info Extensions linking the to the documents |
| [ADI Observation Presence No ADI Example](Observation-no-ADI-example.md) | This is a Observation example for the USCDI5 ADI Observation Data Element to show whether a patient has an advance directive using code 45473-6 (Advance healthcare directive completed). and a SNOMED CT value of "No". |
| [Ahc-Hrsn Item Observation Example 68517-2](Observation-AHC-HRSN-item-example-68517-2.md) | This AHC HRSN Item Example 68517-2 (How many times in the past 12 months have you had 5 or more drinks in a day (males) or 4 or more drinks in a day (females)?) is an example of the**US Core Observation Screening and Assessment Profile**and is referenced by the**ServiceRequest for Rehab Example** |
| [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example](Questionnaire-AUDIT-C.md) | Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] questionnaire example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md) | This is the[LHC Form](https://loinc.org/lhc-forms/)Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Alcohol Use Status Example](Observation-alcohol-use-status.md) | This is an alcohol-use-status example for the**Simple Observation Profile**. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Simple Observations. |
| [Alcoholic Drinks Per Day Example](Observation-alcoholic-drinks-per-day.md) | This is an Alcoholic Drinks Per Day example for the**Simple Observation Profile**. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Simple Observations. |
| [AllergyIntolerance Example](AllergyIntolerance-example.md) | This is a allergyintolerance example for the**US Core AllergyIntolerance Profile**. |
| [AllergyIntolerance Non-pharmacologic Agent Example](AllergyIntolerance-non-pharmacologic-agent-example.md) | This is a allergyintolerance example for the**US Core AllergyIntolerance Profile**representing a non-pharmacologic substance (latex) that the patient is allergic to. |
| [AllergyIntolerance Provenance Example 1](Bundle-allergyintolerance-provenance-example1.md) | This example show how an "inline" search result parameter`_revinclude`will return a FHIR searchset Bundle resource. It contains the AllergyIntolerance resource based on the`patient`search parameter and the last Provenance for the version named in the reference. |
| [AllergyIntolerance Provenance Example 2](Bundle-allergyintolerance-provenance-example2.md) | This example show how an "inline" search result parameter`_revinclude`will return a FHIR searchset Bundle resource. It contains the AllergyIntolerance resource based on the`_id`search parameter and the last Provenance for the version named in the reference. |
| [At Home In Vitro Test Example](Observation-at-home-in-vitro-test.md) | This is an At home in vitro test example for the**US Core Observation Lab Profile**, with a coded result value. |
| [Audit-C Item Example 68517-2](Observation-AUDIT-C-item-example-68517-2.md) | This is a Audit-C Item Example 68517-2 (How many times in the past year have you have X or more drinks in a day?) for the**US Core Observation Screening Assessment Profile** |
| [Audit-C Item Example 68519-8](Observation-AUDIT-C-item-example-68519-8.md) | This is a Audit-C Item Example 68519-8 (How many standard drinks containing alcohol do you have on a typical day?) for the**US Core Observation Screening Assessment Profile** |
| [Audit-C Item Example 68520-6](Observation-AUDIT-C-item-example-68520-6.md) | This is a Audit-C Item Example 68520-6 (How often do you have 6 or more drinks on 1 occasion?) for the**US Core Observation Screening Assessment Profile** |
| [Audit-C Item Example 75626-2](Observation-AUDIT-C-item-example-75626-2.md) | This is a Audit-C Item Example 75626-2 (Total score [AUDIT-C]) for the**US Core Observation Screening Assessment Profile** |
| [Audit-C Panel Example 72109-2](Observation-AUDIT-C-panel-example-72109-2.md) | This is a Audit-C Panel Example 72109-2 (Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]) for the**US Core Observation Screening Assessment Profile** |
| [Average Blood Pressure Example](Observation-average-blood-pressure.md) | This is an average blood pressure example for the**US Core Average Blood Pressure Profile**. |
| [BMI Example](Observation-bmi.md) | This is a BMI example for the**Vitalsigns Profile**. |
| [BP Data Absent Example](Observation-bp-data-absent.md) | This is a bp data absent example for the**Vitalsigns Profile**showing how to reprsesent blood pressure with a missing diastolic measurement. |
| [Basic Metabolic Panel Example](DiagnosticReport-metabolic-panel.md) | This is a basic metabolic panel (BMP) example for the**US Core DiagnosticReport Lab Profile**. |
| [Blood Pressure Example](Observation-blood-pressure.md) | This is a blood pressure example for the**Vitalsigns Profile**. |
| [CBC Example](DiagnosticReport-cbc.md) | This is a CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Capillary refill Time Nail Bed Example](Observation-capillary-refill-time-nail-bed.md) | This is a Capillary refill Time Nail Bed Example for the**Clinical Test Result Observation Profile**. |
| [Care Experience Preference Example](Observation-care-experience-preference.md) | This is an care experience preference example for the**Care Experience Profile**. It is based on the**US Core Simple Observation Profile**. |
| [CareTeam Example](CareTeam-example.md) | This is a careteam example for the**US Core CareTeam Profile**. |
| [Chest Xray Example](Media-chest-xray.md) | This is an example Media xray image that is reference by the**US Core DiagnosticReport Note Profile**. |
| [Cigarette Pack-Years Example](Observation-pack-years-example.md) | This example for the**US Core Smokingstatus Profile**shows a Quantitative result. |
| [Colonoscopy Example](CarePlan-colonoscopy.md) | This is a colonoscopy example for the**US Core CarePlan Profile**. |
| [Condition Duodenal Ulcer Example](Condition-condition-duodenal-ulcer.md) | This example of a US Core Condition Problems and Health Concerns Profile illustrates its use to capture information about a patient's active duodenal ulcer with a category of 'problem-list-item'. |
| [Coverage Example](Coverage-coverage-example.md) | This is a coverage example for the**US Core Coverage Profile**. |
| [DXA Bone density quantitative measurement panel Example](DiagnosticReport-bone-density-report.md) | This is a DXA Bone density quantitative measurement panel report example for the**US Core DiagnosticReport Note Profile**. |
| [DXA Femur-L ArMass BMD Example](Observation-dxa-femur-l-armass-bmd.md) | This is a DXA Femur-L ArMass BMD Example for the**Imaging Result Observation Profile**. |
| [DXA Femur-L T-score BMD Example](Observation-dxa-femur-l-t-score-bmd.md) | This is a DXA Femur-L T-score BMD Example for the**Clinical Test Result Observation Profile**. |
| [DXA Femur-L Z-score BMD Example](Observation-dxa-femur-l-z-score-bmd.md) | This is a DXA Femur-L Z-score BMD Example for the**Imaging Result Observation Profile**. |
| [DXA Hip-L ArMass BMD Example](Observation-dxa-hip-l-armass-bmd.md) | This is a DXA Hip-L ArMass BMD Example for the**Imaging Result Observation Profile**. |
| [DXA Hip-L T-score BMD Example](Observation-dxa-hip-l-t-score-bmd.md) | This is a DXA Hip-L T-score BMD Example for the**Imaging Result Observation Profile**. |
| [DXA Hip-L Z-score BMD Example](Observation-dxa-hip-l-z-score-bmd.md) | This is a DXA Hip-L Z-score BMD Example for the**Imaging Result Observation Profile**. |
| [Deceased Patient Example](Patient-deceased-example.md) | This is a deceased patient example for the**US Core Patient Profile**. |
| [Device Defib Example](Device-udi-2.md) | This is a Device defib example for the**US Core Implantable Device Profile**. |
| [Device Knee Example](Device-udi-3.md) | This is a Device knee example for the**US Core Implantable Device Profile**. |
| [DiagnosticReport Cardiology Report Example](DiagnosticReport-cardiology-report.md) | This is a DiagnosticReport cardiology report example for the**US Core DiagnosticReport Note Profile**. |
| [DiagnosticReport Chest Xray Report Example](DiagnosticReport-chest-xray-report.md) | This is a DiagnosticReport chest xray report example for the**US Core DiagnosticReport Note Profile**. |
| [Discharge Summary Example](DocumentReference-discharge-summary.md) | This is a discharge summary example for the**US Core DocumentReference**. It is used in the[Write Note Example](StructureDefinition-us-core-documentreference.md#mandatory-operation). |
| [Docref Example 1](Bundle-docref-example-1.md) | This bundle is a the response to a $docref operation and contains an example**US Core DocumentReference**. It is used in[Example 1: Request the latest CCD](StructureDefinition-us-core-documentreference.md#mandatory-operation). |
| [Docref Example 2](Bundle-docref-example-2.md) | This bundle is a the response to a $docref operation and contains an examples of**US Core DocumentReference**. It is used in[Example 2: Request Procedure Notes and Discharge Summaries for 2019](StructureDefinition-us-core-documentreference.md#mandatory-operation). |
| [DocumentReference DNR](DocumentReference-adi-dnr.md) | This is a an example of an DNR (Do Not Resuscitate) PDF attachment for the**US Core ADI DocumentReference Profile** |
| [DocumentReference Living Will](DocumentReference-living-will.md) | This is a an example of Living Will PDF attachment for the**US Core ADI DocumentReference Profile** |
| [DocumentReference POLST (PDF)](DocumentReference-polst.md) | This is a an example of POLST (PDF) for the**US Core ADI DocumentReference Profile** |
| [EKG Strip Image](Media-ekg-strip.md) | This is an example Media image that is reference by the**US Core DiagnosticReport Note Profile**. |
| [EKG impression Example](Observation-ekg-impression.md) | This is a EKG impression Example for the**Clinical Test Result Observation Profile**. |
| [EKG lead Example](Observation-ekg-lead.md) | This is a EKG lead Example for the**Clinical Test Result Observation Profile**. |
| [Encounter 1 Example](Encounter-example-1.md) | This is a encounter 1 example for the**US Core Encounter Profile**. |
| [Encounter 1036 Example](Encounter-1036.md) | This is a encounter 1036 example for the**Encounter Profile**. |
| [Encounter Delivery Example](Encounter-delivery.md) | This is a patient delivery encounter example for the**Encounter Profile**. |
| [Encounter Diagnosis Example 1](Condition-encounter-diagnosis-example1.md) | This example of a US Core Condition Encounter Diagnosis Profile illustrates its use to capture information about a patient's encounter diagnosis. |
| [Encounter Diagnosis Example 2](Condition-encounter-diagnosis-example2.md) | This example of a US Core Condition Encounter Diagnosis Profile illustrates its use to capture information about a patient's encounter diagnosis. |
| [Episode Summary Example](DocumentReference-episode-summary.md) | This is a episode summary example for the**US Core DocumentReference Profile**. |
| [Erythrocytes Example](Observation-cbc-erythrocytes.md) | This is a erythrocytes example for the**US Core Observation Lab Profile**and CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Evs Item Example 68516-4](Observation-EVS-item-example-68516-4.md) | This is a Evs Item Example 68516-4 (On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise?) for the**US Core Observation Screening Assessment Profile** |
| [Evs Item Example 89555-7](Observation-EVS-item-example-89555-7.md) | This is a Evs Item Example 89555-7 (How many D per W did you engage in moderate to strenuous physical activity in the last 30D) for the**US Core Observation Screening Assessment Profile** |
| [Evs Panel Example 89574-8](Observation-EVS-panel-example-89574-8.md) | This is a Evs Panel Example 89574-8 (Exercise Vital Sign (EVS)) for the**US Core Observation Screening Assessment Profile** |
| [Exercise Per Day Example](Observation-exercise-per-day.md) | This is an minutes exercise per day example for the**Simple Observation Profile**. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Simple Observations. |
| [Exercise Per Week Example](Observation-exercise-per-week.md) | This is a days exercise per week example for the**Simple Observation Profile**. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Simple Observations. |
| [Exercise Vital Sign Questionnaire Example](Questionnaire-exercise-vital-sign.md) | This is the[LHC Form](https://loinc.org/lhc-forms/)Exercise Vital Sign (EVS) Questionnaire Example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md) | This is the[LHC Form](https://loinc.org/lhc-forms/)Exercise Vital Sign (EVS) QuestionnaireResponse Example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Goal 1 Example](Goal-goal-1.md) | This is a goal 1 example for the**US Core Goal Profile**and demonstrates use free text for Goal.description. |
| [Goal 2 Example](Goal-goal-sdoh-2.md) | This is a goal 2 example for the**US Core Goal Profile**and demonstrates use of a code for Goal.description. |
| [HL7East Example](Location-hl7east.md) | This is a HL7East example for the**US Core Location Profile**. |
| [HVS Item Example 88122-7](Observation-HVS-item-example-88122-7.md) | This is a HVS Item Example 88122-7 ((I/We) worried whether (my/our) food would run out before (I/we) got money to buy more.) for the**US Core Observation Screening Assessment Profile** |
| [HVS Item Example 88123-5](Observation-HVS-item-example-88123-5.md) | This is a HVS Item Example 88123-5 (The food that (I/we) bought just didn't last, and (I/we) didn't have money to get more.) for the**US Core Observation Screening Assessment Profile** |
| [HVS Item Example 88124-3](Observation-HVS-item-example-88124-3.md) | This is a HVS Item Example 88124-3 (Food insecurity risk) for the**US Core Observation Screening Assessment Profile** |
| [HVSPanel Example 88121-9](Observation-HVS-panel-example-88121-9.md) | This is a HVSPanel Example 88121-9 (Hunger Vital Sign [HVS]) for the**US Core Observation Screening Assessment Profile** |
| [Head Circumference Example](Observation-head-circumference.md) | This is a head circumference example for the**US Core Head Circumference Profile**. |
| [Health Concern Example](Condition-health-concern-example.md) | This example of a US Core Condition Problems and Health Concerns Profile illustrates its use to capture information about a patient's health concern. |
| [Heart Rate Example](Observation-heart-rate.md) | This is a heart rate example for the**Vitalsigns Profile**. |
| [Heart rate rhythm Example](Observation-heart-rate-rhythm.md) | This is a Heart rate rhythm Example for the**Clinical Test Result Observation Profile**. |
| [Height Example](Observation-height.md) | This is a height example for the**Vitalsigns Profile**. |
| [Hematocrit Example](Observation-cbc-hematocrit.md) | This is a hematocrit example for the**US Core Observation Lab Profile**and CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Hemoglobin Example](Observation-cbc-hemoglobin.md) | This is a hemoglobin example for the**US Core Observation Lab Profile**and CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Hospital Location](Location-hospital.md) | This is an example hospital location for the**US Core Location Profile**using three coding type, showing SNOMED CT, HSLOC, and v3-RoleCode concepts. |
| [Immunization Example 1](Immunization-imm-1.md) | This is an example for the**US Core Immunization Profile**. |
| [Jugular vein distension Example](Observation-jugular-vein-distension.md) | This is a Jugular vein distension Example for the**Clinical Test Result Observation Profile**. |
| [Length Example](Observation-length.md) | This is a length example for the**Vitalsigns Profile**which shows how body length (typically used for infants) is represented using 8306-3 -**Body height - lying**as an additional observation code. |
| [Leukocytes Example](Observation-cbc-leukocytes.md) | This is a Leukocytes example for the**US Core Observation Lab Profile**and CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Lipemic Serum Specimen Example](Specimen-example-serum-lipemic.md) | This is a serum specimen example for the**US Core Specimen Profile**. It demonstrates the use of the USCDI requirements for specimen condition using SNOMED CT codes |
| [MCH Example](Observation-cbc-mch.md) | This is a MCH example for the**US Core Observation Lab Profile**. It is also used in the CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [MCHC Example](Observation-cbc-mchc.md) | This is a MCHC example for the**US Core Observation Lab Profile**. It is also used in the CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [MCV Example](Observation-cbc-mcv.md) | This is a MCV example for the**US Core Observation Lab Profile**. It is also used in the CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Medication Dispense Example](MedicationDispense-medicationdispense-example.md) | This is a dispense example for the**US Core MedicationDispense Profile**. |
| [MedicationRequest Coded Oral Axid Example](MedicationRequest-medicationrequest-coded-oral-axid.md) | This is an prescribed oral solution example for the**US Core MedicationRequest Profile**. It represents the medication and reason using codes. |
| [MedicationRequest Contained Oral Axid Example](MedicationRequest-medicationrequest-contained-oral-axid.md) | This is an prescribed oral solution example for the**US Core MedicationRequest Profile**. It represents the medication as a contained Medication resource. |
| [MedicationRequest Referenced Oral Axid Example](MedicationRequest-medicationrequest-referenced-oral-axid.md) | This is an prescribed oral solution example for the**US Core MedicationRequest Profile**. It represents the medication and reason as reference Medication and Condition resources. |
| [MedicationRequest Self Tylenol Example](MedicationRequest-self-tylenol.md) | This is a "self-prescribed" tylenol example for the**MedicationRequest Profile**. |
| [Missing Coded Data Example](CareTeam-missing-coded-data-example.md) | This is an example to demonstrate the using 'unknown' from the**DataAbsentReason Code System**when data is missing for a CareTeam resource where the mandatory`CareTeam.participant.role`value is unknown. |
| [OFC Percentile Example](Observation-ofc-percentile.md) | This is a OFC percentile example for the**Head Occipital Frontal Circumference Percentile Profile**. |
| [Observation SatO2 FiO2 Example](Observation-satO2-fiO2.md) | This is a observation satO2 fiO2 example for the**US Core Pulse Oximetry Profile**representing a spO2 value with a for a patient on 6 l/min of O2 suppplemental oxygen. |
| [Occupation Observation Example](Observation-observation-occupation.md) | This example of the**US Core Observation Occupation Profile**documents a nursing assistant's work type. |
| [Occupation Observation Example: Industry Unknown](Observation-observation-occupation-industry-unknown.md) | This example of the**US Core Observation Occupation Profile**represents a situation where the occupation is known, but the industry is not. |
| [Occupation Observation Example: Unknown Occupation](Observation-observation-occupation-unknown.md) | This example of the**US Core Observation Occupation Profile**represents a situation where the industry is known, but the occupation is not. |
| [Organization 2 Example](Organization-example-organization-2.md) | This is a organization 2 example for the**US Core Organization Profile**. |
| [Organization Acme Lab Example](Organization-acme-lab.md) | This is an example laboratory example using the**US Core Organization Profile**. |
| [Organization Acme Payer Example](Organization-acme-payer.md) | This is an example payer using the**US Core Organization Profile**. |
| [Organization Holy Healthcare Example](Organization-holy-healthcare.md) | This is an example managing organization using the**US Core Organization Profile**. |
| [Oxygen Saturation Example](Observation-oxygen-saturation.md) | This is a typical oxygen saturation example for the**US Core Pulse Oximetry Profile**on room air where no oxygen concentration is recorded. |
| [P-R interval {EKG lead} Example](Observation-p-r-interval-ekg-lead.md) | This is a P-R interval {EKG lead} Example for the**Clinical Test Result Observation Profile**. |
| [PHQ9 Item Example 44250-9](Observation-PHQ9-item-example-44250-9.md) | This is a PHQ9 Item Example 44250-9 (Little interest or pleasure in doing things in last 2 weeks) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44251-7](Observation-PHQ9-item-example-44251-7.md) | This is a PHQ9 Item Example 44251-7 (Poor appetite or overeating) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44252-5](Observation-PHQ9-item-example-44252-5.md) | This is a PHQ9 Item Example 44252-5 (Trouble concentrating on things, such as reading the newspaper or watching television) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44253-3](Observation-PHQ9-item-example-44253-3.md) | This is a PHQ9 Item Example 44253-3 (Moving or speaking so slowly that other people could have noticed. Or the opposite-being so fidgety or restless that you have been moving around a lot more than usual) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44254-1](Observation-PHQ9-item-example-44254-1.md) | This is a PHQ9 Item Example 44254-1 (Feeling tired or having little energy) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44255-8](Observation-PHQ9-item-example-44255-8.md) | This is a PHQ9 Item Example 44255-8 (Feeling down, depressed, or hopeless in last 2 weeks) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44258-2](Observation-PHQ9-item-example-44258-2.md) | This is a PHQ9 Item Example 44258-2 (Feeling bad about yourself-or that you are a failure or have let yourself or your family down) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44259-0](Observation-PHQ9-item-example-44259-0.md) | This is a PHQ9 Item Example 44259-0 (Trouble falling or staying asleep, or sleeping too much) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44260-8](Observation-PHQ9-item-example-44260-8.md) | This is a PHQ9 Item Example 44260-8 (Thoughts that you would be better off dead, or of hurting yourself in some way) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 44261-6](Observation-PHQ9-item-example-44261-6.md) | This is a PHQ9 Item Example 44261-6 (Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Item Example 69722-7](Observation-PHQ9-item-example-69722-7.md) | This is a PHQ9 Item Example 69722-7 (How difficult have these problems made it for you to do your work, take care of things at home, or get along with other people?) for the**US Core Observation Screening Assessment Profile** |
| [PHQ9 Panel Example 44249-1](Observation-PHQ9-panel-example-44249-1.md) | This is a PHQ9 Panel Example 44249-1 (PHQ-9 quick depression assessment panel [Reported.PHQ]) for the**US Core Observation Screening Assessment Profile** |
| [PRAPARE Panel Example 93043-8](Observation-PRAPARE-panel-example-93043-8.md) | This is a Prapare Panel Example 93043-8 (Personal characteristics) for the**US Core Observation Screening Assessment Profile** |
| [Patient Child Example](Patient-child-example.md) | This is a patient child example for the**US Core Patient Profile**. |
| [Patient Example](Patient-example.md) | This is a patient example for the**US Core Patient Profile**. |
| [Patient Infant Example](Patient-infant-example.md) | This is a patient infant example for the**US Core Patient Profile**. |
| [Patient Niece Example](RelatedPerson-shaw-niece.md) | This is a patient niece example for the**US Core RelatedPerson Profile Profile**. |
| [Pediatric BMI Example](Observation-pediatric-bmi-example.md) | This is a pediatric BMI example for the**Pediatric BMI For Age Profile**. |
| [Pediatric Wt Example](Observation-pediatric-wt-example.md) | This is a pediatric wt example for the**Pediatric Weight For Height Profile**. |
| [Platelets Example](Observation-cbc-platelets.md) | This is a Platelets example for the**US Core Observation Lab Profile**and CBC example for the**US Core DiagnosticReport Lab Profile**. |
| [Practitioner 1 Example](Practitioner-practitioner-1.md) | This is a practitioner 1 example for the**US Core Practitioner Profile**. |
| [Practitioner 2 Example](Practitioner-practitioner-2.md) | This is a practitioner 2 example for the**US Core Practitioner Profile**. |
| [Practitioner Pharmacist Example](Practitioner-practitioner-pharmacist.md) | This is a pharmacist example using the**US Core Practitioner Profile**. |
| [PractitionerRole_Practitioner_Endpoint_Bundle_Example Example](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md) | This is a PractitionerRole_Practitioner_Endpoint_Bundle_Example example for the**Bundle Profile**. |
| [Prapare Item Example 54899-0](Observation-PRAPARE-item-example-54899-0.md) | This is a Prapare Item Example 54899-0 (Preferred language) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 56051-6](Observation-PRAPARE-item-example-56051-6.md) | This is a Prapare Item Example 56051-6 (Do you consider yourself Hispanic/Latino?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 56799-0](Observation-PRAPARE-item-example-56799-0.md) | This is a Prapare Item Example 56799-0 (Address) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 63512-8](Observation-PRAPARE-item-example-63512-8.md) | This is a Prapare Item Example 63512-8 (How many people are living or staying at this address?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 63586-2](Observation-PRAPARE-item-example-63586-2.md) | This is a Prapare Item Example 63586-2 (What was your best estimate of the total income of all family members from all sources, before taxes, in last year?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 67875-5](Observation-PRAPARE-item-example-67875-5.md) | This is a Prapare Item Example 67875-5 (Employment status current) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 71802-3](Observation-PRAPARE-item-example-71802-3.md) | This is a Prapare Item Example 71802-3 (Housing status) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 76437-3](Observation-PRAPARE-item-example-76437-3.md) | This is a Prapare Item Example 76437-3 (Primary insurance) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 76501-6](Observation-PRAPARE-item-example-76501-6.md) | This is a Prapare Item Example 76501-6 (Within the last year, have you been afraid of your partner or ex-partner?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 82589-3](Observation-PRAPARE-item-example-82589-3.md) | This is a Prapare Item Example 82589-3 (Highest level of educ) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93026-3](Observation-PRAPARE-item-example-93026-3.md) | This is a Prapare Item Example 93026-3 (Do you feel physically and emotionally safe where you currently live?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93027-1](Observation-PRAPARE-item-example-93027-1.md) | This is a Prapare Item Example 93027-1 (Are you a refugee?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93028-9](Observation-PRAPARE-item-example-93028-9.md) | This is a Prapare Item Example 93028-9 (In the past year, have you spent more than 2 nights in a row in a jail, prison, detention center, or juvenile correctional facility?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93029-7](Observation-PRAPARE-item-example-93029-7.md) | This is a Prapare Item Example 93029-7 (How often do you see or talk to people that you care about and feel close to (For example: talking to friends on the phone, visiting friends or family, going to church or club meetings)?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93030-5](Observation-PRAPARE-item-example-93030-5.md) | This is a Prapare Item Example 93030-5 (Has lack of transportation kept you from medical appointments, meetings, work, or from getting things needed for daily living?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93033-9](Observation-PRAPARE-item-example-93033-9.md) | This is a Prapare Item Example 93033-9 (Are you worried about losing your housing?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93034-7](Observation-PRAPARE-item-example-93034-7.md) | This is a Prapare Item Example 93034-7 (Have you been discharged from the armed forces of the United States?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93035-4](Observation-PRAPARE-item-example-93035-4.md) | This is a Prapare Item Example 93035-4 (At any point in the past 2 years, has season or migrant farm work been your or your family's main source of income?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Item Example 93038-8](Observation-PRAPARE-item-example-93038-8.md) | This is a Prapare Item Example 93038-8 (Stress is when someone feels tense, nervous, anxious or can't sleep at night because their mind is troubled. How stressed are you?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Multiselect-Item Example 32624-9-Answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md) | This is a Prapare Multiselect-Item Example 32624-9-Answer0 (Race) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Multiselect-Item Example 32624-9-Answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md) | This is a Prapare Multiselect-Item Example 32624-9-Answer1 (Race) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Multiselect-Item Example 93031-3-Answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md) | This is a Prapare Multiselect-Item Example 93031-3-Answer0 (In the past year, have you or any family members you live with been unable to get any of the following when it was really needed?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Multiselect-Item Example 93031-3-Answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md) | This is a Prapare Multiselect-Item Example 93031-3-Answer1 (In the past year, have you or any family members you live with been unable to get any of the following when it was really needed?) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Panel Example 93025-5](Observation-PRAPARE-panel-example-93025-5.md) | This is a Prapare Panel Example 93025-5 (Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Panel Example 93039-6](Observation-PRAPARE-panel-example-93039-6.md) | This is a Prapare Panel Example 93039-6 (Optional additional questions) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Panel Example 93040-4](Observation-PRAPARE-panel-example-93040-4.md) | This is a Prapare Panel Example 93040-4 (Social and emotional health) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Panel Example 93041-2](Observation-PRAPARE-panel-example-93041-2.md) | This is a Prapare Panel Example 93041-2 (Money and resources) for the**US Core Observation Screening Assessment Profile** |
| [Prapare Panel Example 93042-0](Observation-PRAPARE-panel-example-93042-0.md) | This is a Prapare Panel Example 93042-0 (Family and home) for the**US Core Observation Screening Assessment Profile** |
| [Pregnancy Intent Observation Example](Observation-pregnancy-intent.md) | This is a pregnancy intent example for the**US Core Observation Pregnancy Intent Profile**. |
| [Pregnancy Status Observation Example](Observation-pregnancy-status.md) | This is a pregnancy status example for the**US Core Observation Pregnancy Status Profile**. |
| [Procedure Defibrillator Implant Example](Procedure-defib-implant.md) | This**US Core Procedure Profile**is an example of an Defibrillator implant Procedure. In this example, the reason for a referral is communicated through `Procedure.code'. |
| [Pulse intensity Palpation Example](Observation-pulse-intensity-palpation.md) | This is a Pulse intensity Palpation Example for the**Clinical Test Result Observation Profile**. |
| [Q-T interval {EKG lead} Example](Observation-q-t-interval-ekg-lead.md) | This is a Q-T interval {EKG lead} Example for the**Clinical Test Result Observation Profile**. |
| [QRS dur {EKG lead} Example](Observation-qrs-dur-ekg-lead.md) | This is a QRS dur {EKG lead} Example for the**Clinical Test Result Observation Profile**. |
| [Questionnaire Hunger Vital Sign (HVS) Example](Questionnaire-hunger-vital-sign-example.md) | An example of an SDC Questionnaire that represents the Hunger Vital Sign Example questionnaire defined in LOINC (code 88121-9). The example is generated using the LHC-Forms SDC Questionnaire App. |
| [Questionnaire PHQ-9 Example](Questionnaire-phq-9-example.md) | An example of a SDC Questionnaire that represents the Hunger Vital Sign Example questionnaire defined in LOINC (code 44249-1). This example is generated using the LHC-Forms SDC Questionnaire App. |
| [Questionnaire PRAPARE Example](Questionnaire-prapare-example.md) | An example of an SDC Questionnaire that represents the Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE] questionnaire defined in LOINC (code 93025-5). This example is generated using the LHC-Forms SDC Questionnaire App. |
| [QuestionnaireResponse Glascow Coma Score Example](QuestionnaireResponse-glascow-coma-score.md) | This example of a US Core QuestionnaireResponse references a non-FHIR survey instrument (in this case a pdf) instead of a FHIR Questionnaire. |
| [QuestionnaireResponse Hunger Vital Sign (HVS) Example](QuestionnaireResponse-hunger-vital-sign-example.md) | An example of a US Core QuestionnaireResponse that represents questions and selected answers from the Hunger Vital Sign Example questionnaire defined in LOINC (code 88122-7). This example is generated using the LHC-Forms SDC Questionnaire App. |
| [QuestionnaireResponse PHQ-9 Example](QuestionnaireResponse-phq-9-example.md) | An example of a US Core QuestionnaireResponse that represents questions and selected answers from the Patient Health Questionnaire (PHQ-9) questionnaire defined in LOINC (code 44249-1). The example is generated using the LHC-Forms SDC Questionnaire App. |
| [QuestionnaireResponse PRAPARE Example](QuestionnaireResponse-prapare-example.md) | This is the QuestionnaireResponse example that is referenced by the**US Core Observation Screening Assessment Profile**PRAPARE examples. This example is generated using the LHC-Forms SDC Questionnaire App. |
| [Rehab Example](Procedure-rehab.md) | This is a rehab example for the**US Core Procedure Profile**. |
| [Respiratory Rate Example](Observation-respiratory-rate.md) | This is a respiratory rate example for the**Vitalsigns Profile**. |
| [SDOH Problem/Health Concern Example](Condition-condition-SDOH-example.md) | This example of a US Core Condition Problems and Health Concerns Profile illustrates its use to capture information about a patient's SDOH Problem/Health Concern. |
| [Saint Luke W Endpoint Example](Organization-saint-luke-w-endpoint.md) | This is a saint luke w endpoint example for the**US Core Organization Profile**. |
| [Serum BUN Example](Observation-serum-bun.md) | This is a BUN example for the**US Core Observation Lab Profile**. |
| [Serum CO2 Example](Observation-serum-co2.md) | This is a serum CO2 example for the**US Core Observation Lab Profile**. |
| [Serum Calcium Example](Observation-serum-calcium.md) | This is a serum calcium example for the**US Core Observation Lab Profile**. |
| [Serum Chloride Example](Observation-serum-chloride.md) | This is a serum chloride example for the**US Core Observation Lab Profile**. |
| [Serum Creatinine Example](Observation-serum-creatinine.md) | This is a serum creatinine example for the**US Core Observation Lab Profile**. |
| [Serum Glucose Example](Observation-serum-glucose.md) | This is a serum glucose example for the**US Core Observation Lab Profile**. |
| [Serum Potassium Example](Observation-serum-potassium.md) | This is a serum potassium example for the**US Core Observation Lab Profile**. |
| [Serum Sodium Example](Observation-serum-sodium.md) | This is a serum sodium example for the**US Core Observation Lab Profile**. |
| [Serum Specimen Example](Specimen-specimen-example-serum.md) | This is a serum specimen example for the**US Core Specimen Profile**. |
| [ServiceRequest BMP Example](ServiceRequest-bmp.md) | This is an example requesting a Laboratory Order (Basic Metabolic Panel) for a patient using the**US Core ServiceRequest Profile**. |
| [ServiceRequest CBC Example](ServiceRequest-cbc.md) | This is an example requesting a Laboratory Order (CBC panel) for a patient using the**US Core ServiceRequest Profile Profile**. |
| [ServiceRequest Chest XRay Example](ServiceRequest-chest-xray.md) | This is an example requesting a Imaging Order (Portable XR Chest Views) for a patient using the**US Core ServiceRequest Profile Profile**. |
| [ServiceRequest EKG Example](ServiceRequest-ekg.md) | This is an example requesting a Clinical Test Order (EKG panel) for a patient using the**US Core ServiceRequest Profile Profile**. |
| [ServiceRequest Food Pantry Referral Example](ServiceRequest-foodpantry-referral.md) | This is a food pantry referral request example using the**US Core ServiceRequest Profile**. |
| [ServiceRequest for Rehab Example](ServiceRequest-rehab.md) | This is an example requesting alcohol rehab sessions for a patient using the**US Core ServiceRequest Profile Profile**. |
| [Simple Observation Cognitive Status Example](Observation-simple-observation-cognitive-status.md) | This**US Core Simple Observation Profile**is a cognitive status determination which is not based on any formal assessment tool or survey. (This example is adapted from the[PACIO Cognitive Status Implementation Guide ver 1.0.0](https://build.fhir.org/ig/HL7/PACIO-CognitiveStatus/).) |
| [Simple Observation Disability Status Example](Observation-simple-observation-disability-status.md) | This**US Core Simple Observation Profile**is a degree of depression severity determination which is based on the results of a PHQ-9 (Patient Health Questionnaire-9) screening. |
| [Simple Observation Functional Status Example](Observation-simple-observation-functional-status.md) | This**US Core Simple Observation Profile**is a functional status determination which is not based on any formal assessment tool or survey. |
| [Simple Observation SDOH Example](Observation-simple-observation-sdoh.md) | This**US Core Simple Observation Profile**is a SDOH determination which is not based on any formal assessment tool or survey. |
| [Some Day Smoker Example](Observation-some-day-smoker.md) | This example for the**US Core Smokingstatus Profile**shows a coded result. |
| [Substance Use Status Example](Observation-substance-use-status.md) | This is an Substance-use-status example for the**Simple Observation Profile**. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Simple Observations. |
| [Taps Item Example 75889-6](Observation-TAPS-item-example-75889-6.md) | This is a Taps Item Example 75889-6 (How often have you had four or more drinks in one day during the past year [Reported]) for the**US Core Observation Screening Assessment Profile** |
| [Taps Item Example 88037-7](Observation-TAPS-item-example-88037-7.md) | This is a Taps Item Example 88037-7 (How often have you had five or more drinks in one day during the past year [Reported]) for the**US Core Observation Screening Assessment Profile** |
| [Taps Item Example 96842-0](Observation-TAPS-item-example-96842-0.md) | This is a Taps Item Example 96842-0 (How often have you used any tobacco product in past 12 months) for the**US Core Observation Screening Assessment Profile** |
| [Taps Item Example 96843-8](Observation-TAPS-item-example-96843-8.md) | This is a Taps Item Example 96843-8 (How often have you used illegal or recreational drugs in past 12 months) for the**US Core Observation Screening Assessment Profile** |
| [Taps Item Example 96844-6](Observation-TAPS-item-example-96844-6.md) | This is a Taps Item Example 96844-6 (How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months [TAPS]) for the**US Core Observation Screening Assessment Profile** |
| [Taps Panel Example 96841-2](Observation-TAPS-panel-example-96841-2.md) | This is a Taps Panel Example 96841-2 (Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]) for the**US Core Observation Screening Assessment Profile** |
| [Temperature Example](Observation-temperature.md) | This is a temperature example for the**Vitalsigns Profile**. |
| [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) Questionnaire Example](Questionnaire-TAPS.md) | Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] questionnaire example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Tobacco, Alcohol, Prescription medications, and other Substance use screen (TAPS) QuestionnaireResponse Example](QuestionnaireResponse-TAPS.md) | This is the[LHC Form](https://loinc.org/lhc-forms/)Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] QuestionnaireResponse example. It is based on the on US Core[Screening and Assessments](screening-and-assessments.md)guidance using Questionnaire/QuestionnaireResponse resources. |
| [Treatment Intervention Preference Example](Observation-treatment-intervention-preference.md) | This is an intervention preference example for the**Treatment Intervention Profile**. It is based on the**US Core Simple Observation Profile**. |
| [UDI 1 Example](Device-udi-1.md) | This is a UDI 1 example for the**US Core Implantable Device Profile**. |
| [US Core Version 3.1.1 Model Definition](Library-uscore-3.1.1-model-definition.md) | Model definition for US Core Version 3.1.1 Model |
| [US Core Version 4.0.0 Model Definition](Library-uscore-4.0.0-model-definition.md) | Model definition for US Core Version 4.0.0 Model |
| [US Core Version 5.0.1 Model Definition](Library-uscore-5.0.1-model-definition.md) | Model definition for US Core Version 5.0.1 Model |
| [US Core Version 6.1.0 Model Definition](Library-uscore-6.1.0-model-definition.md) | Model definition for US Core Version 6.1.0 Model |
| [US Core Version 7.0.0 Model Definition](Library-uscore-7.0.0-model-definition.md) | Model definition for US Core Version 7.0.0 Model |
| [US Core Version 8.0.1 Model Definition](Library-uscore-8.0.1-model-definition.md) | Model definition for US Core Version 8.0.1 Model |
| [Urine Specimen Example](Specimen-specimen-example-urine.md) | This is a urine specimen example for the**US Core Specimen Profile**. |
| [Urobilinogen Example](Observation-urobilinogen.md) | This is a urobilinogen example for the**US Core Observation Lab Profile**. |
| [Uscore Med1 Example](Medication-uscore-med1.md) | This is a uscore med1 example for the**US Core Medication Profile**. |
| [Uscore Med2 Example](Medication-uscore-med2.md) | This is a uscore med2 example for the**US Core Medication Profile**. |
| [Weight Example](Observation-weight.md) | This is a weight example for the**Vitalsigns Profile**. |
| [Whole Blood Specimen Example](Specimen-specimen-example-whole-blood.md) | This is a whole blood specimen example for the**US Core Specimen Profile**. |
| [Xray Chest Findings Example](Observation-xray-chest-findings.md) | This example of a US Core Observation Clinical Result Profile illustrates its use to capture information about a patient's radiology study findings. |
| [Xray Chest Impression Example](Observation-xray-chest-impression.md) | This example of a US Core Observation Clinical Result Profile illustrates its use to capture information about a patient's radiology study impression. |

