# US Core Tribal Affiliation Extension - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Tribal Affiliation Extension**

## Extension: US Core Tribal Affiliation Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreTribalAffiliationExtension |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.66 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

This Extension profile represents a tribe or band with which a person associates and, optionally, whether they are enrolled.

**Context of Use**

**Profile Specific Implementation Guidance:**

* `isEnrolled` is an optional sub-extension for systems that choose to collect this information

**Usage info**

**Usages:**

* Use this Extension: [US Core Patient Profile](StructureDefinition-us-core-patient.md)
* Examples for this Extension: [Patient/example](Patient-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-tribal-affiliation)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-tribal-affiliation.csv), [Excel](StructureDefinition-us-core-tribal-affiliation.xlsx), [Schematron](StructureDefinition-us-core-tribal-affiliation.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-tribal-affiliation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.66"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreTribalAffiliationExtension",
  "title" : "US Core Tribal Affiliation Extension",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This Extension profile represents a tribe or band with which a person associates and, optionally, whether they are enrolled.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    },
    {
      "type" : "element",
      "expression" : "RelatedPerson"
    },
    {
      "type" : "element",
      "expression" : "Person"
    },
    {
      "type" : "element",
      "expression" : "Practitioner"
    },
    {
      "type" : "element",
      "expression" : "FamilyMemberHistory"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Tribal Affiliation Extension",
        "definition" : "A tribe or band with which a person associates whether or not they are an enrolled member.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:tribalAffiliation",
        "path" : "Extension.extension",
        "sliceName" : "tribalAffiliation",
        "short" : "Affiliated tribe or band name",
        "definition" : "Affiliated tribe or band name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:tribalAffiliation.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "tribalAffiliation"
      },
      {
        "id" : "Extension.extension:tribalAffiliation.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Tribal Entity US",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "Tribal Entity recognized by the United States Bureau Of Indian Affairs.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-TribalEntityUS"
        }
      },
      {
        "id" : "Extension.extension:isEnrolled",
        "path" : "Extension.extension",
        "sliceName" : "isEnrolled",
        "short" : "Enrolled tribe member",
        "definition" : "Whether the individual is an enrolled tribe member",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension"
          }
        ]
      },
      {
        "id" : "Extension.extension:isEnrolled.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "isEnrolled"
      },
      {
        "id" : "Extension.extension:isEnrolled.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 0,
        "max" : "0"
      }
    ]
  }
}

```
