# US Core Race Extension - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Race Extension**

## Extension: US Core Race Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-race | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreRaceExtension |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.57 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality. The race codes used to represent these concepts are based upon the [Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) which includes over 900 concepts for representing race and ethnicity of which 921 reference race. The race concepts are grouped by and pre-mapped to the 5 OMB race categories:

* American Indian or Alaska Native
* Asian
* Black or African American
* Native Hawaiian or Other Pacific Islander
* White.

Complies with 2015 Edition Common Clinical Data Set for patient race.

**Context of Use**

### Profile specific implementation guidance

* This Complex Extension for race allows one or more race codes of which: 
* [Must Support](must-support.md) at least one code from OMB Race Categories
* May include additional race codes from CDC Race Codes
* Must include a text description of race
 
* A [`race`](SearchParameter-us-core-race.md) search parameter has been defined for this extension. However, there are no race search requirements for the Client or Server.

**Usage info**

**Usages:**

* Use this Extension: [US Core Patient Profile](StructureDefinition-us-core-patient.md)
* Examples for this Extension: [Patient/child-example](Patient-child-example.md), [Patient/deceased-example](Patient-deceased-example.md), [Patient/example](Patient-example.md) and [Patient/infant-example](Patient-infant-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-race)

**Changes since version 7.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-race.csv), [Excel](StructureDefinition-us-core-race.xlsx), [Schematron](StructureDefinition-us-core-race.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-race",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.57"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreRaceExtension",
  "title" : "US Core Race Extension",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The race codes used to represent these concepts are based upon the [Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) which includes over 900 concepts for representing race and ethnicity of which 921 reference race.  The race concepts are grouped by and pre-mapped to the 5 OMB race categories:\n\n - American Indian or Alaska Native\n - Asian\n - Black or African American\n - Native Hawaiian or Other Pacific Islander\n - White.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "Complies with 2015 Edition Common Clinical Data Set for patient race.",
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    },
    {
      "type" : "element",
      "expression" : "RelatedPerson"
    },
    {
      "type" : "element",
      "expression" : "Person"
    },
    {
      "type" : "element",
      "expression" : "Practitioner"
    },
    {
      "type" : "element",
      "expression" : "FamilyMemberHistory"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "US Core Race Extension",
        "definition" : "Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The race codes used to represent these concepts are based upon the [Race & Ethnicity - CDC (CDCREC)](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) which includes over 900 concepts for representing race and ethnicity of which 921 reference race.  The race concepts are grouped by and pre-mapped to the 5 OMB race categories:\n\n   - American Indian or Alaska Native\n   - Asian\n   - Black or African American\n   - Native Hawaiian or Other Pacific Islander\n   - White.",
        "min" : 0,
        "max" : "1",
        "condition" : ["us-core-23"],
        "constraint" : [
          {
            "key" : "us-core-23",
            "severity" : "error",
            "human" : "If \"ASKU\" or \"UNK\" are present, then no other OMB race categories can be present.",
            "expression" : "extension.where(url = 'ombCategory').value.where(code in 'ASKU'|'UNK').exists() implies extension.where(url = 'ombCategory').count() = 1"
          }
        ]
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:ombCategory",
        "path" : "Extension.extension",
        "sliceName" : "ombCategory",
        "short" : "American Indian or Alaska Native|Asian|Black or African American|Native Hawaiian or Other Pacific Islander|White",
        "definition" : "The 5 race category codes according to the [OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf).",
        "min" : 0,
        "max" : "6",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "iso11179",
            "map" : "/ClinicalDocument/recordTarget/patientRole/patient/raceCode"
          }
        ]
      },
      {
        "id" : "Extension.extension:ombCategory.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "ombCategory"
      },
      {
        "id" : "Extension.extension:ombCategory.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "The 5 race category codes according to the [OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf).",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.4.642.2.575"
        }
      },
      {
        "id" : "Extension.extension:detailed",
        "path" : "Extension.extension",
        "sliceName" : "detailed",
        "short" : "Extended race codes",
        "definition" : "The 900+ CDC race codes that are grouped under one of the 5 OMB race category codes:.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mapping" : [
          {
            "identity" : "iso11179",
            "map" : "/ClinicalDocument/recordTarget/patientRole/patient/sdtc:raceCode"
          }
        ]
      },
      {
        "id" : "Extension.extension:detailed.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "detailed"
      },
      {
        "id" : "Extension.extension:detailed.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.25"
        }
      },
      {
        "id" : "Extension.extension:text",
        "path" : "Extension.extension",
        "sliceName" : "text",
        "short" : "Race Text",
        "definition" : "Plain text representation of the race concept(s).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:text.url",
        "path" : "Extension.extension.url",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "text"
      },
      {
        "id" : "Extension.extension:text.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 0,
        "max" : "0"
      }
    ]
  }
}

```
