# US Core QuestionnaireResponse Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core QuestionnaireResponse Profile**

## Resource Profile: US Core QuestionnaireResponse Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreQuestionnaireResponseProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.56 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core QuestionaireResponse Profile inherits from the[Structured Data Capture (SDC) Questionnaire Response Profile](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaireresponse.html). This profile sets minimum expectations for the QuestionnaireResponse resource to record, search, and fetch retrieve captures the responses to form/survey and assessment tools such as the**Protocol for Responding to and Assessing Patients\u2019 Assets, Risks, and Experiences (PRAPARE) Survey**. It specifies which core**additional**elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Before reviewing this profile, implementers are encouraged to read the Screening and Assessments guidance page, which documents the process of recording responses and capturing assertions/determinations resulting from surveys and questionnaires. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for survey screening results for a patient.
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) screening results results belonging to a Patient

### Mandatory and Must Support Data Elements

**In addition to** the Mandatory and Must Support data elements in the SDC QuestionnaireResponse Profile, the following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements. Note that the **Key Elements Table** view aggregates all the Must Support elements between this profile and its parent profiles.

**Each QuestionnaireResponse Must Have:**

1. a reference back to the assessment upon which it is based
1. a status
1. a patient
1. the date the answers were gathered

**Each QuestionnaireResponse Must Support:**

1. a practitioner who recorded the answers*
1. the questions and decimal, string, and coded answers
* each question must have an identifier pointing to the question

*see guidance below

**Profile Specific Implementation Guidance:**

* The SDC profile (from which this profile is derived) focuses on the constraints appropriate to capturing the "answer(s)" to a FHIR [Questionnaire](http://hl7.org/fhir/R4/questionnaire.html) and demands that the Questionnaire's canonical URL be specified. If the QuestionnaireResponse is based on a non-FHIR form: 
1. Construct a FHIR Questionnaire representing**at least**the relevant metadata (in other words, the questions may be omitted).
1. Communicates the identifier of the non-FHIR form instead of the canonical URI using the[US Core Extension Questionnaire URI](StructureDefinition-us-core-extension-questionnaire-uri.md)extension.
 
* See the [Screening and Assessments](screening-and-assessments.md) guidance page for how this profile or Observations can represent SDOH assessments.
* QuestionnaireResponse can be searched using the standard FHIR RESTful API search parameters. Example searches are shown in the [Quick Start](#notes) section below. Although search [chains](http://hl7.org/fhir/R4/search.html#chaining) through the associated Questionnaire can be used to query QuestionnaireResponse by item, individual responses are not directly searchable in QuestionnaireResponse. To search directly for individual responses, they must be "parsed" into a searchable form - i.e., to a local FHIR or non-FHIR data store such as a database or FHIR Observations.
* The basic workflow for creating, discovering, retrieving, and data-extracting FHIR Questionnaire and QuestionnaireResponse is thoroughly documented in the [Structured Data Capture (SDC)](http://hl7.org/fhir/uv/sdc) implementation guide.

* *The profile elements `QuestionnaireResponse.author and QuestionnaireResponse.source` communicate the [individual level provenance](basic-provenance.md#individual-level-provenance) author data corresponding to the U.S. Core Data for Interoperability (USCDI) Provenance Author Data Elements.

**Usages:**

* Refer to this Profile: [US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md) and [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)
* Examples for this Profile: [QuestionnaireResponse/AUDIT-C](QuestionnaireResponse-AUDIT-C.md), [QuestionnaireResponse/TAPS](QuestionnaireResponse-TAPS.md), [QuestionnaireResponse/exercise-vital-sign](QuestionnaireResponse-exercise-vital-sign.md), [QuestionnaireResponse/glascow-coma-score](QuestionnaireResponse-glascow-coma-score.md)...Show 3 more,[QuestionnaireResponse/hunger-vital-sign-example](QuestionnaireResponse-hunger-vital-sign-example.md),[QuestionnaireResponse/phq-9-example](QuestionnaireResponse-phq-9-example.md)and[QuestionnaireResponse/prapare-example](QuestionnaireResponse-prapare-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-questionnaireresponse)

**Changes since version 7.0.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-questionnaireresponse.csv), [Excel](StructureDefinition-us-core-questionnaireresponse.xlsx), [Schematron](StructureDefinition-us-core-questionnaireresponse.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to completed questionnnaire, survey and assessement data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/QuestionnaireResponse.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support both read QuestionnaireResponse by`id`**AND**QuestionnaireResponse search using the**[`_id`](SearchParameter-us-core-questionnaireresponse-id.md)**search parameter:`GET [base]/QuestionnaireResponse/[id]`or`GET [base]/QuestionnaireResponse?_id=[id]`Example:
1. GET [base]/!QuestionnaireResponse/AHC-HRSN-screening-example
1. GET [base]/!QuestionnaireResponse/?_id=AHC-HRSN-screening-example
**Implementation Notes:**([how to search by the logical id](http://hl7.org/fhir/R4/references.html#logical)of the resource)
1. **SHALL**support searching for all questionnaireresponses for a patient using the**[`patient`](SearchParameter-us-core-questionnaireresponse-patient.md)**search parameter:`GET [base]/QuestionnaireResponse?patient={Type/}[id]`Example:
1. GET [base]/QuestionnaireResponse?patient=1032702
**Implementation Notes:**Fetches a bundle of all QuestionnaireResponse resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-questionnaireresponse-patient.md)**and**[`status`](SearchParameter-us-core-questionnaireresponse-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/QuestionnaireResponse?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/QuestionnaireResponse?patient=1137192&status=completed
**Implementation Notes:**Fetches a bundle of all QuestionnaireResponse resources for the specified patient and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-questionnaireresponse-patient.md)**and**[`authored`](SearchParameter-us-core-questionnaireresponse-authored.md)**search parameters:
* including support for these `authored` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `authored` (e.g.`authored=[date]&authored=[date]]&...`)
`GET [base]/QuestionnaireResponse?patient={Type/}[id]&authored={gt|lt|ge|le}[date]{&authored={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/QuestionnaireResponse?patient=113192&date=ge2021
**Implementation Notes:**Fetches a bundle of all QuestionnaireResponse resources for the specified patient and date ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-questionnaireresponse-patient.md)**and**[`questionnaire`](SearchParameter-us-core-questionnaireresponse-questionnaire.md)**search parameters:`GET [base]/QuestionnaireResponse?patient={Type/}[id]&questionnaire={Type/}[id]`Example:
1. GET [base]/QuestionnaireResponse?patient=113192&questionnaire=http://hl7.org/fhir/us/sdoh-clinicalcare/Questionnaire/SDOHCC-QuestionnaireHungerVitalSign
**Implementation Notes:**Fetches a bundle of all QuestionnaireResponse resources for the specified patient that have been completed against a specified form. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))

#### Searching QuestionnaireResponse by Context

Searching a patient's QuestionnaireResponses by specific context such as those defined in [US Core Category](CodeSystem-us-core-category.md) can be achieved by querying the metadata on the associated Questionnaire. Specifically, [`Questionnaire.useContext`](http://hl7.org/fhir/R4/questionnaire-definitions.html#Questionnaire.useContext) with a code="focus" and value of "sdoh"/"functionalStatus"/etc. could be accomplished using a chained search:

`GET [base]/QuestionnaireResponse?subject=Patient/123&questionnaire.context-type-value=focus$sdoh`



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-questionnaireresponse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.56"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreQuestionnaireResponseProfile",
  "title" : "US Core QuestionnaireResponse Profile",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core QuestionaireResponse Profile inherits from the [Structured  Data Capture (SDC) Questionnaire Response Profile](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaireresponse.html).   This profile sets minimum expectations for the QuestionnaireResponse resource to record, search, and fetch retrieve captures the responses to form/survey and assessment tools such as the *Protocol for Responding to and Assessing Patients\\u2019 Assets, Risks, and Experiences (PRAPARE) Survey*.  It specifies which core *additional* elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used.  Before reviewing this profile, implementers are encouraged to read the Screening and Assessments guidance page, which documents the process of recording responses and capturing assertions/determinations resulting from surveys and questionnaires.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "QuestionnaireResponse",
  "baseDefinition" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "QuestionnaireResponse",
        "path" : "QuestionnaireResponse",
        "short" : "US Core Profile based on SDC QuestionnaireResponse"
      },
      {
        "id" : "QuestionnaireResponse.questionnaire",
        "path" : "QuestionnaireResponse.questionnaire",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.questionnaire.extension:url",
        "path" : "QuestionnaireResponse.questionnaire.extension",
        "sliceName" : "url",
        "short" : "The location where a non-FHIR questionnaire/survey form can be found.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.status",
        "path" : "QuestionnaireResponse.status",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.subject",
        "path" : "QuestionnaireResponse.subject",
        "comment" : "-",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Resource"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.authored",
        "path" : "QuestionnaireResponse.authored",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.author",
        "path" : "QuestionnaireResponse.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item",
        "path" : "QuestionnaireResponse.item",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item.answer.value[x]",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "date"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "time"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "decimal"
          },
          {
            "code" : "integer"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Coding"
          },
          {
            "code" : "uri"
          },
          {
            "code" : "Quantity"
          },
          {
            "code" : "Attachment"
          },
          {
            "code" : "Reference"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
