# US Core Provenance Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Provenance Profile**

## Resource Profile: US Core Provenance Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreProvenance |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.54 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Provenance Profile inherits from the FHIR[Provenance](https://hl7.org/fhir/R4/provenance.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Provenance resource to record, search, and fetch provenance information associated with a record. It covers the minimal (basic) information to support lineage of information. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present and constrains how the elements are used. Before reviewing this profile, implementers are encouraged to read the Basic Provenance guidance page, which documents several key use cases, specifically, the organization responsible for the most recent action on the resource. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for the Provenance records associated with an Allergy
* Query for the Provenance records associated with a Problem

### Mandatory and Must Support Data Elements

The following data elements are mandatory (i.e., data MUST be present) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Provenance Must Have:**

1. a reference to the resource(s) the Provenance record is supporting (target)
1. a date and time for the activity

**Each Provenance Must Support:**

1. the author organization responsible for the information
1. the transmitter that provided the information
1. the transmitter organization responsible for the transmission (if the transmitter is a device, the transmitter organization must also be valued).

**Profile Specific Implementation Guidance:**

*  The US Core Provenance resource **SHALL** be supported for these US Core resource types: 
* AllergyIntolerance
* CarePlan
* CareTeam
* Condition
* Coverage
* Device
* DiagnosticReport
* DocumentReference
* Encounter
* Goal
* Immunization
* MedicationDispense
* MedicationRequest
* Observation
* Patient
* Procedure
* QuestionnaireResponse
* RelatedPerson
* ServiceRequest
 

* If a system receives a provider in `Provenance.agent.who` as free text, they must capture who sent them the information as the organization. On request, they **SHALL** provide this organization as the source and **MAY** include the free text provider.
* Systems that need to know the activity has occurred **SHOULD** populate the activity.

**Usages:**

* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-provenance)

**Changes since version 7.0.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-provenance.csv), [Excel](StructureDefinition-us-core-provenance.xlsx), [Schematron](StructureDefinition-us-core-provenance.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to provenance data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Provenance.rs`

#### Mandatory Search Parameters:

The following search parameters, search parameter combinations SHALL be supported. Any listed search parameter [modifiers](http://hl7.org/fhir/R4/search.html#modifiers), [comparators](http://hl7.org/fhir/R4/search.html#prefix), [chains](http://hl7.org/fhir/R4/search.html#chaining) and [composites](http://hl7.org/fhir/R4/search.html#combining) SHALL also be supported UNLESS they are listed as "optional" in which case they**SHOULD** be supported:

1. **SHALL**support searching for all US Core Profile resource types[listed above](#prov-white-list)for a patient and all the Provenance records for those resources using a combination of the`patient`and**[`_revinclude`](http://hl7.org/fhir/R4/search.html#include)**search parameters:`GET [base]/[Resource]?patient=[id]&_revinclude=Provenance:target`Example:
1. GET [base]/AllergyIntolerance?patient=[id]5&_revinclude=Provenance:target
**Implementation Notes:**
* Fetches a bundle of all resources of a particular type for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)) and any corresponding Provenance resources.
* The "inline" search result parameter `_revinclude` will return the last Provenance for the version named in the reference. To return all the Provenance resources associated with a resource irrespective of its version, search against Provenance using the `target` search parameter.
* See the [AllergyIntolerance Provenance Example 1](Bundle-allergyintolerance-provenance-example1.md) Bundle.

1. **SHALL**support searching for a particular instance of a US Core Profile resource type[listed above](#prov-white-list)and all its Provenance resources using combination of the`_id`and the**[`_revinclude`](http://hl7.org/fhir/R4/search.html#include)**search parameters:`GET [base]/[Resource]?_id=[id]&_revinclude=Provenance:target`Example:
1. GET [base]/AllergyIntolerance?_id=[id]&_revinclude=Provenance:target
**Implementation Notes:**
* Fetches a Bundle of a resource of a particular type (within the Clients authorization scope) and any corresponding Provenance resources. ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
* The "inline" search result parameter `_revinclude` will return the last Provenance for the version named in the reference. To return all the Provenance resources associated with a resource irrespective of its version, search against Provenance using the `target` search parameter.
* See the [AllergyIntolerance Provenance Example 2](Bundle-allergyintolerance-provenance-example2.md) Bundle.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-provenance",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.54"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreProvenance",
  "title" : "US Core Provenance Profile",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Provenance Profile inherits from the FHIR [Provenance](https://hl7.org/fhir/R4/provenance.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the Provenance resource to record, search, and fetch provenance information associated with a record. It covers the minimal (basic) information to support lineage of information. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present and constrains how the elements are used.   Before reviewing this profile, implementers are encouraged to read the Basic Provenance guidance page, which documents several key use cases, specifically, the organization responsible for the most recent action on the resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhirauditevent",
      "uri" : "http://hl7.org/fhir/auditevent",
      "name" : "FHIR AuditEvent Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Provenance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Provenance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Provenance",
        "path" : "Provenance",
        "short" : "US Core Provenance",
        "alias" : ["Basic Provenance"],
        "mustSupport" : false
      },
      {
        "id" : "Provenance.target",
        "path" : "Provenance.target",
        "short" : "The Resource this Provenance record supports",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.target.reference",
        "path" : "Provenance.target.reference",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.recorded",
        "path" : "Provenance.recorded",
        "short" : "Timestamp when the activity was recorded / updated",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent",
        "path" : "Provenance.agent",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "constraint" : [
          {
            "key" : "provenance-1",
            "severity" : "error",
            "human" : "onBehalfOf SHALL be present when Provenance.agent.who is a Practitioner or Device",
            "expression" : "who.exists((resolve() is Practitioner) or (resolve() is Device)) implies onBehalfOf.exists()"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type",
        "path" : "Provenance.agent.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-provenance-participant-type"
        }
      },
      {
        "id" : "Provenance.agent.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.onBehalfOf",
        "path" : "Provenance.agent.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor",
        "path" : "Provenance.agent",
        "sliceName" : "ProvenanceAuthor",
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor.type",
        "path" : "Provenance.agent.type",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
              "code" : "author"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter",
        "path" : "Provenance.agent",
        "sliceName" : "ProvenanceTransmitter",
        "definition" : "The entity that provided the copy to your system.",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter.type",
        "path" : "Provenance.agent.type",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type",
              "code" : "transmitter"
            }
          ]
        },
        "mustSupport" : true
      }
    ]
  }
}

```
