

<!-- Source = /Users/ehaas/Documents/FHIR/US-Core/input/. This file is generated by SearchParameterMakerR4.ipynb Do not edit directly. -->{% include quickstart-intro.md %}

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL** support both read Patient by `id` **AND** Patient search using the **[`_id`](SearchParameter-us-core-patient-id.html)** search parameter:

    `GET [base]/Patient/[id]` or `GET [base]/Patient?_id=[id]`

    Example:
    
      1. GET [base]/Patient/1032702
      1. GET [base]/Patient?_id=1032702

    *Implementation Notes:*  ([how to search by the logical id] of the resource)

1. **SHALL** support searching a patient by an identifier such as a MPI using the **[`identifier`](SearchParameter-us-core-patient-identifier.html)** search parameter:

    `GET [base]/Patient?identifier={system|}[code]`

    Example:
    
      1. GET [base]/Patient?identifier=http://hospital.smarthealthit.org\|1032702

    *Implementation Notes:* Fetches a bundle containing any Patient resources matching the identifier ([how to search by token])

1. **SHALL** support searching for a patient by a Server defined search that matches any of the string fields in the HumanName, including family, given, prefix, suffix, and/or text using the **[`name`](SearchParameter-us-core-patient-name.html)** search parameter:

    `GET [base]/Patient?name=[string]`

    Example:
    
      1. GET [base]/Patient?name=Shaw

    *Implementation Notes:* Fetches a bundle of all Patient resources matching the name ([how to search by string])

1. **SHALL** support searching using the combination of the **[`birthdate`](SearchParameter-us-core-patient-birthdate.html)** and **[`name`](SearchParameter-us-core-patient-name.html)** search parameters:

    `GET [base]/Patient?birthdate=[date]&name=[string]`

    Example:
    
      1. GET [base]/Patient?name=Shaw&amp;birthdate=2007-03-20

    *Implementation Notes:* Fetches a bundle of all Patient resources matching the specified birthdate and name ([how to search by date] and [how to search by string])


#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD** support searching using the combination of the **[`birthdate`](SearchParameter-us-core-patient-birthdate.html)** and **[`family`](SearchParameter-us-core-patient-family.html)** search parameters:

    `GET [base]/Patient?birthdate=[date]&family=[string]`

    Example:
    
      1. GET [base]/Patient?family=Shaw&amp;birthdate=2007-03-20

    *Implementation Notes:* Fetches a bundle of all Patient resources matching the specified birthdate and family ([how to search by date] and [how to search by string])

1. **SHOULD** support searching using the combination of the **[`death-date`](SearchParameter-us-core-patient-death-date.html)** and **[`family`](SearchParameter-us-core-patient-family.html)** search parameters:

    `GET [base]/Patient?death-date=[date]&family=[string]`

    Example:
    
      1. GET [base]/Patient?family=Shaw&amp;death-date=2022-07-22

    *Implementation Notes:* Fetches a bundle of all Patient resources matching the specified death-date and family ([how to search by date] and [how to search by string])

{% include link-list.md %}