# US Core Observation Sexual Orientation Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Observation Sexual Orientation Profile**

## Resource Profile: US Core Observation Sexual Orientation Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation | *Version*:8.0.1 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreObservationSexualOrientationProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.48 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Observation Sexual Orientation Profile inherits from the FHIR[Observation](https://hl7.org/fhir/R4/observation.html)resource; refer to refer to it for scope and usage definitions. This Profile sets minimum expectations for the Observation resource to record, search, and fetch sexual orientation observations associated with a patient. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for sexual orientation
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) sexual orientation

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Observation Must Have:**

1. a status
1. a fixed code for sexual orientation
1. a patient

**Each Observation Must Support:**

1. a time indicating when the observation was made
1. a sexual orientation value

**Profile Specific Implementation Guidance:**

* This profile is no longer a USCDI requirement. Implementers can look to the FHIR specification and other implementation guides for usage.
* Additional codes that translate or map to the Observation code (e.g., local codes) are allowed.

**Usages:**

* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-observation-sexual-orientation)

**Changes since version 7.0.0:**

* The resource metadata has changed (description)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-observation-sexual-orientation.csv), [Excel](StructureDefinition-us-core-observation-sexual-orientation.xlsx), [Schematron](StructureDefinition-us-core-observation-sexual-orientation.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**search parameters:`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory`Example:
1. GET [base]/Observation?patient=1134281&amp;category=http://terminology.hl7.org/CodeSystem/observation-category|social-history
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and a category code =`laboratory`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1134281&amp;code=http://loinc.org|76690-7
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and observation code(s). SHOULD support search by multiple report codes. The Observation`code`parameter searches `Observation.code only. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history&date=ge2018-03-14T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and a category code =`laboratory`([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`status`](SearchParameter-us-core-observation-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|laboratory&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=1134281&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history&status=final
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category =`laboratory`and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`category`](SearchParameter-us-core-observation-category.md)**and**[`_lastUpdated`](SearchParameter-us-core-observation-lastupdated.md)**search parameters:
* including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&http://terminology.hl7.org/CodeSystem/observation-category|social-history&_lastUpdated=ge2024-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and category and _lastUpdated. See the US Core General Guidance page for[Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-observation-patient.md)**and**[`code`](SearchParameter-us-core-observation-code.md)**and**[`date`](SearchParameter-us-core-observation-date.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]Observation?patient=555580&code=http://loinc.org|76690-7&date=ge2019-01-01T00:00:00Z
**Implementation Notes:**Fetches a bundle of all Observation resources for the specified patient and date and report code(s). SHOULD support search by multiple report codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-observation-sexual-orientation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.48"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreObservationSexualOrientationProfile",
  "title" : "US Core Observation Sexual Orientation Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Observation Sexual Orientation Profile inherits from the FHIR [Observation](https://hl7.org/fhir/R4/observation.html) resource; refer to refer to it for scope and usage definitions. This Profile sets minimum expectations for the Observation resource to record, search, and fetch sexual orientation observations associated with a patient. It specifies which core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "us-core-2",
            "severity" : "error",
            "human" : "If there is no component or hasMember element then either a value[x] or a data absent reason must be present",
            "expression" : "(component.empty() and hasMember.empty()) implies (dataAbsentReason.exists() or value.exists())",
            "xpath" : "exists(f:component) or exists(f:hasMember) or exists(f:*[starts-with(local-name(.), 'value')]) or exists(f:dataAbsentReason)"
          }
        ],
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-status"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.status"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Sexual Orientation",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "76690-7"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.subject"
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "definition" : "This records the time during which the patient had identified their emotional, romantic, sexual, or affectional attraction to another person.",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Timing"
          },
          {
            "code" : "instant"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Observation.effective[x]"
          }
        ]
      },
      {
        "id" : "Observation.valueCodeableConcept",
        "path" : "Observation.valueCodeableConcept",
        "short" : "Sexual Orientation",
        "definition" : "The Sexual Orientation value.",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SexualOrientation"
            }
          ],
          "strength" : "extensible",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.11"
        }
      }
    ]
  }
}

```
