# US Core Implantable Device Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Implantable Device Profile**

## Resource Profile: US Core Implantable Device Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreImplantableDeviceProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.32 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Device Profile inherits from the FHIR[Device](https://hl7.org/fhir/R4/device.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI)**Unique Device Identifier - Implantable**Data Element. It sets minimum expectations for the Device resource to record, search, and fetch UDI information associated with a patient's implantable device(s). It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a Patient's Implantable Devices
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) a Patient Implantable Device

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Implantable Device Must Have:**

1. a code identifying the type of device
1. a patient

In addition, the following data elements must be supported if the data is present in the sending system ([Must Support](must-support.md) definition):

**Each Implantable Device Must Support:**

1. A Unique Device Identifier (UDI) numeric or alphanumeric code as the Human Readable Form (HRF) string representation of the barcode
1. The Device Identifier (UDI-DI)
1. the manufacture date
1. the expiration date
1. the lot number
1. the serial number
1. the distinct identifier (i.e., the distinct identification code)

**Profile Specific Implementation Guidance:**

* For non-implantable devices (for example, software or crutches), use the base FHIR Device resource or other use case-specific Device profiles.
* This profile supports the requirement to retrieve a 170.315(a)(14) [Implantable device list](https://www.healthit.gov/test-method/implantable-device-list). It follows the [HL7 Cross Paradigm Implementation Guide: UDI Pattern](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=487) guidelines for exchanging information about the use and implantation of medical devices in patients. 
* A unique device identifier (UDI) is a unique numeric or alphanumeric code. There is a machine-readable version (AIDC - the Automatic Identification and Data Capture) and a human-readable version of the UDI (HRF - Human Readable Form string). This profile specifies that only the HRF must be supported. Considering the complexity of parsing AIDCs, there is **no expectation** at this time that one converts an AIDC to HRF upon receipt from a FHIR source that is not conformant to this profile or is using another interchange standard (e.g., C-CDA, HL7 v2, etc.). The UDI generally consists of a mandatory Device Identifier (DI) and a conditional Production identifier (PI) that identifies one or more of the five UDI-PI elements. The UDI and its components are mapped to the US Core Implantable Device Profile elements in the table below:
* Implementers are encouraged to use the FDA Global UDI Database (GUDID) and associated APIs to parse and validate the UDI:
 
* Implantable medical devices with UDI information **SHALL** represent the UDI code in `Device.udiCarrier.carrierHRF`. All five UDI-PI elements defined in the UDI code may not always be present in every UDI instance. However, those UDI-PI elements present **SHALL** be represented in the corresponding US Core Implantable Device Profile elements.


  UDI may not be present in all scenarios, such as historical implantable devices, patient-reported implant information, payer-reported devices, or improperly documented implants. If UDI is not present and the manufacturer or model number information is available, they **SHOULD** be included to support historical reports of implantable medical devices as follows:
* Servers **SHOULD** support query by `Device.type` to allow Clients to request the patient's devices by a specific type. Note: `Device.type` is too granular to differentiate implantable vs. non-implantable devices.
* The [Quick Start](#search) section below describes searching for all devices. Records of implanted devices **MAY** be queried against UDI data, including:


  Implementers **MAY** also adopt custom SearchParameters for searching by:

**Usages:**

* Examples for this Profile: [Device/udi-1](Device-udi-1.md), [Device/udi-2](Device-udi-2.md) and [Device/udi-3](Device-udi-3.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-implantable-device)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-implantable-device.csv), [Excel](StructureDefinition-us-core-implantable-device.xlsx), [Schematron](StructureDefinition-us-core-implantable-device.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to implantable device data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Device.rs`

#### Mandatory Search Parameters:

1. **SHALL**support searching for all devices for a patient, including implantable devices using the**[`patient`](SearchParameter-us-core-device-patient.md)**search parameter:`GET [base]/Device?patient={Type/}[id]`Example:
1. GET [base]/Device?patient=1137192
**Implementation Notes:**Fetches a bundle of all Device resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-device-patient.md)**and**[`type`](SearchParameter-us-core-device-type.md)**search parameters:`GET [base]/Device?patient={Type/}[id]&type={system|}[code]`Example:
1. GET [base]/Device?patient=1316024&type=http://snomed.info/sct|468063009
**Implementation Notes:**Fetches a bundle of all Device resources for the specified patient and type. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-device-patient.md)**and**[`status`](SearchParameter-us-core-device-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/Device?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Device?patient=1316024&status=active
**Implementation Notes:**Fetches a bundle of all Device resources for the specified patient and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-implantable-device",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.32"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreImplantableDeviceProfile",
  "title" : "US Core Implantable Device Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Device Profile inherits from the FHIR [Device](https://hl7.org/fhir/R4/device.html) resource; refer to it for scope and usage definitions. This profile meets the requirements of the U.S. Core Data for Interoperability (USCDI) *Unique Device  Identifier - Implantable* Data Element. It sets minimum expectations for the Device resource to record, search, and fetch UDI information associated with a patient's implantable device(s). It specifies which core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device",
        "path" : "Device",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Device"
          }
        ]
      },
      {
        "id" : "Device.udiCarrier",
        "path" : "Device.udiCarrier",
        "comment" : "Some devices may not have UDI information (for example. historical data or patient reported data).",
        "max" : "1",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Device.udi"
          }
        ]
      },
      {
        "id" : "Device.udiCarrier.deviceIdentifier",
        "path" : "Device.udiCarrier.deviceIdentifier",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.udiCarrier.carrierHRF",
        "path" : "Device.udiCarrier.carrierHRF",
        "alias" : ["UDI", "Barcode String"],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Device.udi"
          }
        ]
      },
      {
        "id" : "Device.distinctIdentifier",
        "path" : "Device.distinctIdentifier",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.manufactureDate",
        "path" : "Device.manufactureDate",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.expirationDate",
        "path" : "Device.expirationDate",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.lotNumber",
        "path" : "Device.lotNumber",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.serialNumber",
        "path" : "Device.serialNumber",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "NA (not Supported)"
          }
        ]
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Codes to identify medical devices",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-kind"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Device.type"
          }
        ]
      },
      {
        "id" : "Device.patient",
        "path" : "Device.patient",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "Device.patient"
          }
        ]
      }
    ]
  }
}

```
