

<!-- Source = /Users/ehaas/Documents/FHIR/US-Core/input/. This file is generated by SearchParameterMakerR4.ipynb Do not edit directly. -->{% include quickstart-intro.md %}

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL** support both read Encounter by `id` **AND** Encounter search using the **[`_id`](SearchParameter-us-core-encounter-id.html)** search parameter:

    `GET [base]/Encounter/[id]` or `GET [base]/Encounter?_id=[id]`

    Example:
    
      1. GET [base]/Encounter/12354
      1. GET [base]/Encounter?_id=12354

    *Implementation Notes:* Fetches a single Encounter ([how to search by the logical id] of the resource)

1. **SHALL** support searching for all encounters for a patient using the **[`patient`](SearchParameter-us-core-encounter-patient.html)** search parameter:

    `GET [base]/Encounter?patient={Type/}[id]`

    Example:
    
      1. GET [base]/Encounter?patient=1137192

    *Implementation Notes:* Fetches a bundle of all Encounter resources for the specified patient ([how to search by reference])

1. **SHALL** support searching using the combination of the **[`date`](SearchParameter-us-core-encounter-date.html)** and **[`patient`](SearchParameter-us-core-encounter-patient.html)** search parameters:
    - including support for these `date` comparators: `gt,lt,ge,le`
    - including optional support for *AND* search on `date` (e.g.`date=[date]&date=[date]]&...`)

    `GET [base]/Encounter?date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}&patient={Type/}[id]`

    Example:
    
      1. GET [base]/Encounter?patient=example1&amp;date=ge2019-01-01T00:00:00Z

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified date and patient ([how to search by date] and [how to search by reference])


#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD** support searching for an encounter by an identifier using the **[`identifier`](SearchParameter-us-core-encounter-identifier.html)** search parameter:

     `GET [base]/Encounter?identifier={system|}[code]`

    Example:
    
      1. GET [base]/Encounter?identifier=http://hospital.smarthealthit.org\|1032702

      *Implementation Notes:* Fetches a bundle containing any Encounter resources matching the identifier ([how to search by token])

1. **SHOULD** support searching using the combination of the **[`class`](SearchParameter-us-core-encounter-class.html)** and **[`patient`](SearchParameter-us-core-encounter-patient.html)** search parameters:

    `GET [base]/Encounter?class={system|}[code]&patient={Type/}[id]`

    Example:
    
      1. GET [base]/Encounter?patient=example1&amp;class= http://terminology.hl7.org/CodeSystem/v3-ActCode code\|AMB

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified class and patient ([how to search by reference] and [how to search by token])

1. **SHOULD** support searching using the combination of the **[`patient`](SearchParameter-us-core-encounter-patient.html)** and **[`type`](SearchParameter-us-core-encounter-type.html)** search parameters:

    `GET [base]/Encounter?patient={Type/}[id]&type={system|}[code]`

    Example:
    
      1. GET [base]/Encounter?patient=1137192&amp;type=http://www.ama-assn.org/go/cpt code\|99211

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified patient and type ([how to search by reference] and [how to search by token])

1. **SHOULD** support searching using the combination of the **[`patient`](SearchParameter-us-core-encounter-patient.html)** and **[`location`](SearchParameter-us-core-encounter-location.html)** search parameters:

    `GET [base]/Encounter?patient={Type/}[id]&location={Type/}[id]`

    Example:
    
      1. GET [base]/Encounter?patient=1137192&amp;location=Location/hospital

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified patient and location ([how to search by reference])

1. **SHOULD** support searching using the combination of the **[`patient`](SearchParameter-us-core-encounter-patient.html)** and **[`status`](SearchParameter-us-core-encounter-status.html)** search parameters:

    `GET [base]/Encounter?patient={Type/}[id]&status={system|}[code]`

    Example:
    
      1. GET [base]/Encounter?patient=example1&amp;status=finished

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified patient and status ([how to search by reference] and [how to search by token])

1. **SHOULD** support searching using the combination of the **[`patient`](SearchParameter-us-core-encounter-patient.html)** and **[`discharge-disposition`](SearchParameter-us-core-encounter-discharge-disposition.html)** search parameters:

    `GET [base]/Encounter?patient={Type/}[id]&discharge-disposition={system|}[code]`

    Example:
    
      1. GET [base]/Encounter?patient=example1&amp;discharge-disposition=01

    *Implementation Notes:* Fetches a bundle of all Encounter resources matching the specified patient and discharge-disposition ([how to search by reference] and [how to search by token])

1. **SHOULD** support searching using the combination of the **[`patient`](SearchParameter-us-core-encounter-patient.html)** and **[`_lastUpdated`](SearchParameter-us-core-encounter-lastupdated.html)** search parameters:
    - including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
    - including optional support for *AND* search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)

    `GET [base]/Encounter?patient={Type/}[id]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`

    Example:
    
      1. GET [base]/Encounter?patient=1137192&amp;_lastUpdated=ge2024-01-01T00:00:00Z

    *Implementation Notes:* Fetches a bundle of all Encounter resources for the specified patient and _lastUpdated. See the US Core General Guidance page for [Searching Using lastUpdated]. ([how to search by reference] and [how to search by date])




{% include link-list.md %}