
**Example Usage Scenarios:**

The following are example usage scenarios for the US Core DocumentReference profile. See the [Clinical Notes] section for additional details on using this profile for Clinical Notes:

-   Query for all documents belonging to a Patient
-   Query for a specific Clinical Note type (e.g., Discharge Summary or Continuity of Care Document (CCD))
-   Query for all Clinical Notes belonging to a Patient
-   Write a new Note to a Patient's Chart

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory] definition) or must be supported if the data is present in the sending system ([Must Support] definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views] below provides the formal summary, definitions, and terminology requirements.

**Each DocumentReference Must Have:**

1. a status
1. a code describing the type of document
1. a document category
1. a patient
1. document referenced (content)
1. the MIME type (i.e., contentType) of the document

**Each DocumentReference Must Support:**

1. a business identifier for the DocumentReference (possibly generated by the transcription system or EHR)
1. date and time the reference was created
1. an author
1. a code identifying the specific details about the format of the document — over and above the content's MIME type
1. the patient encounter that is being referenced
1. clinically relevant date

{% include additional-requirements-intro.md type="DocumentReference" %}

1. a document category limited to [The US Core DocumentReferences Type Value Set], which currently consists of a single value, "clinical note."

**Profile Specific Implementation Guidance:**

- See [Clinical Notes]
- The `DocumentReference.type` binding Must Support, at a minimum, the [10 Common Clinical Notes] and may extend to the whole [US Core DocumentReference Type Value Set]
- In addition to the [US Core DocumentReference Category] value set, other category schemes such as the LOINC-based [Document Class Value Set] and [IHE XDSclassCode] may be used to facilitate the sharing of health documents.
- For a C-CDA Clinical Summary of Care (CCD):
   -  The document type code is the LOINC code [34133-9] *Summary of episode note*.


- For C-CDA Clinical Documents
  - The format code in `DocumentReference.content.format` is "urn:hl7-org:sdwg:ccda-structuredBody:2.1".
  - For other CDA documents, Servers SHOULD select the appropriate format code from the [HL7 ValueSet of Format Codes for use with Document Sharing](https://terminology.hl7.org/6.2.0/ValueSet-v3-HL7FormatCodes.html).


- The DocumentReference resources can represent the referenced content using either an address where the document can be retrieved using `DocumentReference.content.attachment.url` or the content as inline base64 encoded data using `DocumentReference.content.attachment.data`.
    -  Although both are marked as Must Support, the Server system is not required to support an address and inline base64 encoded data, but **SHALL** support at least one of these elements.
    -  The Client application **SHALL** support both elements.
    -  The `DocumentReference.content.attachment.url` may refer to a FHIR Binary Resource (i.e., [base]/Binary/[id]), FHIR Document Bundle (i.e., [base]/Bundle/[id], or another endpoint).
        - If the referenced a document or file is hosted on a server outside the FHIR server, it should be securely accessible using the same authorization credentials that were used to access the FHIR server. This reduces complexity for the client and improves the user experience.
    -  If there are multiple `DocumentReference.content` element repetitions, these **SHALL** all represent the same document in different formats or attachment metadata. The content element **SHALL NOT** contain different versions of the same content. For version handling, use multiple DocumentReferences with `DocumentReference.relatesTo`. 
- Every DocumentReference must have a responsible Organization. The organization responsible for the DocumentReference **SHALL** be present either in `DocumentReference.custodian` or accessible in the Provenance resource targeting the DocumentReference using `Provenance.agent.who` or `Provenance.agent.onBehalfOf`.
   - Some systems may also expose the same organization in referenced Encounter in `Encounter.serviceProvider`.

{% include link-list.md %}
