# US Core DiagnosticReport Profile for Report and Note Exchange - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core DiagnosticReport Profile for Report and Note Exchange**

## Resource Profile: US Core DiagnosticReport Profile for Report and Note Exchange 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreDiagnosticReportProfileNoteExchange |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.21 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core DiagnosticReport Profile for Report and Note Exchange inherits from the FHIR[DiagnosticReport](https://hl7.org/fhir/R4/diagnosticreport.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching Diagnostic Reports and Notes using the DiagnosticReport resource. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a specific clinical test result, such as an electrocardiogram (ECG)
* Query for a specific imaging test result
* Query for a specific Radiology note (e.g., 84178-3 Interventional Radiology Note)
* Query for a category of reports (e.g., all Cardiology reports)

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Diagnostic Report Must Have:**

1. a status
1. a category*
1. a code describing the type of report
1. a patient
1. the diagnostically relevant time (known as the "effective time" and typically the time of the procedure)*

*This element has the following constraint: **SHALL** be present if status is 'partial', 'preliminary', 'final', 'amended', 'corrected', or 'appended'.

**Each Diagnostic Report Must Support:**

1. encounter associated with DiagnosticReport
1. instant the report was released
1. an author (actor) producing the report
1. a results interpreter*
1. a reference to one or more test results
1. a reference to one or more images
1. a reference to the full report (presentedForm)

* see guidance below

**Profile Specific Implementation Guidance:**

* See [Clinical Notes](clinical-notes.md)
* The `DiagnosticReport.category` binding Must Support, at a minimum, the [US Core DiagnosticReport Category Codes](ValueSet-us-core-diagnosticreport-category.md) of Cardiology, Radiology, and Pathology. Other categories may be supported. 
* It is up to the data source to categorize the documents they send. Therefore, Clients need to understand that data categorization is somewhat subjective, and the categorization applied by the source may not align with the Client's expectations. Any linkages between specific LOINC codes and the LP-type codes may be used as guidance. If LOINC develops a hierarchy or categorization to align these concepts, US Core will be updated.
 
* A Server will return how a customer has categorized their reports at a particular site. Categorization of reports is not consistent across sites. (e.g., a system may categorize an orthopedic note as cardiology.)
* For Diagnostic Imaging Reports systems **SHOULD** support using the subset of LOINC codes defined in CONF-DIR-19 in *HL7 Implementation Guide for CDA Release 2: Imaging Integration, Levels 1, 2, and 3, Basic Imaging Reports in CDA and DICOM Diagnostic Imaging Reports (DIR) - Universal Realm, Release 1.0.

* *The profile elements `DiagnosticReport.performer and DiagnosticReport.resultsInterpreter` communicate the [individual level provenance](basic-provenance.md#individual-level-provenance) author data corresponding to the U.S. Core Data for Interoperability (USCDI) Provenance Author Data Elements.
* Diagnostic imaging results in visual images requiring interpretation and clinical test results/reports may also reference images as part of the report. There is no single approach for accessing imaging studies alongside clinical data using a single authorization flow to give patients and providers access to the images.
* The `DiagnosticRequest.basedOn` element connects the DiagnosticReport to the originating order in the EHR. Systems that initiate the order **SHOULD** use this element when reporting the results.

**Usages:**

* Examples for this Profile: [DiagnosticReport/bone-density-report](DiagnosticReport-bone-density-report.md), [DiagnosticReport/cardiology-report](DiagnosticReport-cardiology-report.md) and [DiagnosticReport/chest-xray-report](DiagnosticReport-chest-xray-report.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-diagnosticreport-note)

**Changes since version 7.0.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-diagnosticreport-note.csv), [Excel](StructureDefinition-us-core-diagnosticreport-note.xlsx), [Schematron](StructureDefinition-us-core-diagnosticreport-note.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to clniical note data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/DiagnosticReport.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching for all diagnosticreports for a patient using the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**search parameter:`GET [base]/DiagnosticReport?patient={Type/}[id]`Example:
1. GET [base]/DiagnosticReport?patient=1137192
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`category`](SearchParameter-us-core-diagnosticreport-category.md)**search parameters:`GET [base]/DiagnosticReport?patient={Type/}[id]&category={system|}[code]`Example:
1. GET [base]/DiagnosticReport?patient=f201&category=http://loinc.org|LP29708-2
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and a category code = "LP29708-2" ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`code`](SearchParameter-us-core-diagnosticreport-code.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
`GET [base]/DiagnosticReport?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/DiagnosticReport?patient=1032702&code=http://loinc.org|45033-8
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and report code(s). SHOULD support search by multiple report codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`category`](SearchParameter-us-core-diagnosticreport-category.md)**and**[`date`](SearchParameter-us-core-diagnosticreport-date.md)**search parameters:
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/DiagnosticReport?patient={Type/}[id]&category={system|}[code]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/DiagnosticReport?patient=f201&category=http://loinc.org|LP29708-2&date=ge2010-01-14T00:00:00Z
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and date and a category code = "LP29708-2" ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`status`](SearchParameter-us-core-diagnosticreport-status.md)**search parameters:
* including support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/DiagnosticReport?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/DiagnosticReport?patient=1137192&status=completed
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`category`](SearchParameter-us-core-diagnosticreport-category.md)**and**[`_lastUpdated`](SearchParameter-us-core-diagnosticreport-lastupdated.md)**search parameters:
* including support for these `_lastUpdated` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `_lastUpdated` (e.g.`_lastUpdated=[date]&_lastUpdated=[date]]&...`)
`GET [base]/DiagnosticReport?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/DiagnosticReport?patient=f201&category=http://loinc.org|LP29708-2&_lastUpdated=ge2010-01-14T00:00:00Z
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and category and _lastUpdated. See the US Core General Guidance page for[Searching Using lastUpdated](general-guidance.md#searching-using-lastupdated). ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-diagnosticreport-patient.md)**and**[`code`](SearchParameter-us-core-diagnosticreport-code.md)**and**[`date`](SearchParameter-us-core-diagnosticreport-date.md)**search parameters:
* including optional support for **OR** search on `code` (e.g.`code={system|}[code],{system|}[code],...`)
* including support for these `date` comparators: `gt,lt,ge,le`
* including optional support for **AND** search on `date` (e.g.`date=[date]&date=[date]]&...`)
`GET [base]/DiagnosticReport?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/DiagnosticReport?patient=f201&code=http://loinc.org|45033-8&date=ge2019-01-14T00:00:00Z
**Implementation Notes:**Fetches a bundle of all DiagnosticReport resources for the specified patient and date and report code(s). SHOULD support search by multiple report codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token)and[how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-diagnosticreport-note",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.21"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreDiagnosticReportProfileNoteExchange",
  "title" : "US Core DiagnosticReport Profile for Report and Note Exchange",
  "status" : "active",
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core DiagnosticReport Profile for Report and Note Exchange inherits from the FHIR [DiagnosticReport](https://hl7.org/fhir/R4/diagnosticreport.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for searching and fetching Diagnostic Reports and Notes using the DiagnosticReport resource. It specifies which core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. Before reviewing this profile, implementers are encouraged to read the Clinical Notes Guidance to understand the overlap of the US Core DiagnosticReport Profile for Report and Note exchange and the US Core DocumentReference Profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "alias" : ["Imaging Report", "Radiology Report", "Clinical Test Report"],
        "constraint" : [
          {
            "key" : "us-core-10",
            "severity" : "error",
            "human" : "effective[x] SHALL be present if the status is 'partial', 'preliminary', 'final', 'amended', 'corrected' or 'appended'",
            "expression" : "(status='partial' or status='preliminary' or status='final' or status='amended' or status='corrected' or status='appended' ) implies effective.exists()"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "condition" : ["us-core-10"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status"
        }
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.category:us-core",
        "path" : "DiagnosticReport.category",
        "sliceName" : "us-core",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-category"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "short" : "US Core Report Code",
        "definition" : "The test, panel, report, or note that was ordered.",
        "comment" : "The typical patterns for codes are:  1)  a LOINC code either as a translation from a \"local\" code or as a primary code, or 2)  a local code only if no suitable LOINC exists,  or 3)  both the local and the LOINC translation.   Systems SHALL be capable of sending the local code if one exists.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "LOINC codes",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-report-and-note-codes"
        }
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "short" : "Encounter associated with DiagnosticReport",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "Diagnostically relevant time (typically the time of the procedure)",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "condition" : ["us-core-10"],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter",
        "path" : "DiagnosticReport.resultsInterpreter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab",
              "http://hl7.org/fhir/StructureDefinition/Observation"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "path" : "DiagnosticReport.presentedForm",
        "mustSupport" : true
      }
    ]
  }
}

```
