# US Core Coverage Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Coverage Profile**

## Resource Profile: US Core Coverage Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreCoverageProfile |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.19 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core Coverage Profile inherits from the FHIR[Coverage](https://hl7.org/fhir/R4/coverage.html)resource; refer to it for scope and usage definitions. This profile meets the requirements of the US Core Data for Interoperability (USCDI)**Health Insurance Information**Data Class. It sets minimum expectations for the Coverage resource to record, search, and fetch data related to an individual's insurance coverage for health care. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a patient's insurance coverage
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) a past or present insurance coverage

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile-specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Coverage Must Have:**

1. health insurance member identifier or subscriber id
1. a status
1. the health insurance beneficiary (patient)
1. beneficiary's relationship to the subscriber
1. the health insurance issuer (payer)

**Each Coverage Must Support:**

1. health insurance coverage type (e.g., Medicare)
1. coverage start or end date
1. health insurance group
1. health insurance plan

**Profile Specific Implementation Guidance:**

* There is no single way to indicate that the patient has no coverage using the Coverage resource: 
* `Coverage.status` alone may not indicate whether an individual is covered. The `Coverage.period` needs to be considered as well. For example, the coverage may be expired with a status of "active", or conversely, it may be "canceled" but still have covered claims.
* The absence of a Coverage resource instance may mean the patient has no coverage or the healthcare provider may not know it.
* A `coverage.type` of "81" (Self-pay) **MAY** be used to imply that the patient has no coverage or that an individual or organization other than an insurer is taking responsibility for payment for a portion of the health care costs.
 
* The hierarchical nature of the `Coverage.type` code system "Payer" (also known as the US Public Health Data Consortium Source of Payment Codes) may be unclear in the expansion, and some codes may be inappropriate for the use case. Implementers should refer to the [PHDSC Payer Type Committee User's Guide](https://www.nahdo.org/sites/default/files/2020-12/SourceofPaymentTypologyUsersGuideVersion9.2December2020.pdf) for the Source of Payment Typology when selecting codes.
* If Insurers issue unique member IDs for dependents, then the **memberId** `Coverage.identifier` should be used instead of `Coverage.dependent` to uniquely refer to the dependent with respect to their insurance.

**Usages:**

* Examples for this Profile: [Coverage/coverage-example](Coverage-coverage-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-coverage)

**Changes since version 7.0.0:**

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-coverage.csv), [Excel](StructureDefinition-us-core-coverage.xlsx), [Schematron](StructureDefinition-us-core-coverage.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to coverage data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/Coverage.rs`

#### Mandatory Search Parameters:

1. **SHALL**support searching for all coverages for a patient using the**[`patient`](SearchParameter-us-core-coverage-patient.md)**search parameter:`GET [base]/Coverage?patient={Type/}[id]`Example:
1. GET [base]/Coverage?patient=1137192
**Implementation Notes:**Fetches a bundle of all Coverage resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-coverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.19"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreCoverageProfile",
  "title" : "US Core Coverage Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core Coverage Profile inherits from the FHIR [Coverage](https://hl7.org/fhir/R4/coverage.html) resource; refer to it for scope and usage definitions. This profile meets the requirements of the US Core Data for Interoperability (USCDI) *Health Insurance Information* Data Class. It sets minimum expectations for the Coverage resource to record, search, and fetch data related to an individual's insurance coverage for health care. It specifies which core elements, extensions,  vocabularies, and value sets **SHALL** be present in the resource and constrains how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage",
        "constraint" : [
          {
            "key" : "us-core-15",
            "severity" : "error",
            "human" : "Member Id in Coverage.identifier or Coverage.subscriberId SHALL be present",
            "expression" : "identifier.type.coding.where(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='MB').exists() or subscriberId.exists()",
            "xpath" : "f:identifier or f:subscriberId"
          }
        ]
      },
      {
        "id" : "Coverage.identifier",
        "path" : "Coverage.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "short" : "Member ID and other identifiers",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.identifier:memberid",
        "path" : "Coverage.identifier",
        "sliceName" : "memberid",
        "short" : "Member ID",
        "min" : 0,
        "max" : "1",
        "condition" : ["us-core-15"],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.identifier:memberid.type",
        "path" : "Coverage.identifier.type",
        "short" : "Member Number identifier type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "MB"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Coverage.status",
        "path" : "Coverage.status",
        "comment" : "The `Coverage.status` alone does not indicate whether an individual's coverage is terminated or that the individual is not covered. The `Coverage.period` needs to be considered as well.",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.type",
        "path" : "Coverage.type",
        "comment" : "Identifies if the coverage is PPO, HMO, POS, etc.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "US Public Health Data Consortium Source of Payment Codes",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
        }
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "comment" : "The identifier assigned by the Payer on the subscriber's ID card",
        "condition" : ["us-core-15"],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "comment" : "Identifier for a member assigned by the Payer.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.relationship",
        "path" : "Coverage.relationship",
        "comment" : "Relationship of the member to the person insured (subscriber)",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/subscriber-relationship"
        }
      },
      {
        "id" : "Coverage.period",
        "path" : "Coverage.period",
        "comment" : "Date that the contract became effective and Date that the contract was terminated or coverage changed.",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.payor",
        "path" : "Coverage.payor",
        "comment" : "Issuer of the Policy",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class",
        "path" : "Coverage.class",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on value pattern",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:group",
        "path" : "Coverage.class",
        "sliceName" : "group",
        "short" : "Group",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:group.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "group"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:group.value",
        "path" : "Coverage.class.value",
        "short" : "Group Identifier",
        "comment" : "Employer account identifier",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan",
        "path" : "Coverage.class",
        "sliceName" : "plan",
        "short" : "Plan",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "plan"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:plan.value",
        "path" : "Coverage.class.value",
        "short" : "Plan Number",
        "comment" : "Business concept used by a health plan to describe its benefit offerings",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan.name",
        "path" : "Coverage.class.name",
        "short" : "Plan Name",
        "comment" : "Name of the health plan benefit offering assigned to the Plan Identifier",
        "mustSupport" : true
      }
    ]
  }
}

```
