# US Core CareTeam Profile - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core CareTeam Profile**

## Resource Profile: US Core CareTeam Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreCareTeam |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.42.16 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The US Core CareTeam Profile inherits from the FHIR[CareTeam](https://hl7.org/fhir/R4/careteam.html)resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the CareTeam resource for identifying the Care Team members associated with a patient to promote interoperability and adoption through common implementation. It specifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource and how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption. 

**Example Usage Scenarios:**

The following are example usage scenarios for this profile:

* Query for a Patient's CareTeam
* [Record or update](us-core-roadmap.md#future-candidate-requirements-under-consideration) a Patient's CareTeam

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory](must-support.md) definition) or must be supported if the data is present in the sending system ([Must Support](must-support.md) definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views](#profile) below provides the formal summary, definitions, and terminology requirements.

**Each CareTeam Must Have:**

1. a patient
1. a participant role for each careteam member
1. a reference to each careteam member, which can be:
* a practitioner or practitioner type (doctor, nurse, therapist)*
* a relative, friend, or guardian

*See below for how practitioner members are represented in this Profile.

**Each CareTeam Must Support:**

1. a status code

**Profile Specific Implementation Guidance:**

In order to access care team member's names, identifiers, locations, and contact information, the CareTeam profile supports several types of care team participants. They are represented as references to other profiles and include the following three profiles, which are marked as Must Support:

1. US Core Practitioner Profile
1. US Core PractitionerRole Profile
1. US Core RelatedPerson Profile

* Although **both** US Core Practitioner Profile and US Core PractitionerRole are Must Support, the Server system is not required to support references to both, but **SHALL** support **at least** one of them.
* The Client application **SHALL** support all three profile references.
* Because the US Core PractitionerRole Profile supplies the provider's location and contact information and a reference to the Practitioner, Server systems **SHOULD** reference it instead of the US Core Practitioner Profile. The quick start section below shows an example of how to access the practitioner name and identifier.
* Servers that support only US Core Practitioner Profile and do not support the US Core PractitionerRole Profile **SHALL** provide implementation-specific guidance on how to access a provider's location and contact information using only the Practitioner resource.

**Usages:**

* Refer to this Profile: [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md), [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md), [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md), [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md)...Show 12 more,[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md),[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md),[US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md),[US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md),[US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md),[US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md),[US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md),[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md),[US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md),[US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md),[US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md)and[US Core Vital Signs Profile](StructureDefinition-us-core-vital-signs.md)
* Examples for this Profile: [US-Core example CareTeam](CareTeam-example.md) and [US-Core example CareTeam](CareTeam-missing-coded-data-example.md)
* CapabilityStatements using this Profile: [US Core Client CapabilityStatement](CapabilityStatement-us-core-client.md) and [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.core|current/StructureDefinition/us-core-careteam)

**Changes since version 7.0.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-us-core-careteam.csv), [Excel](StructureDefinition-us-core-careteam.xlsx), [Schematron](StructureDefinition-us-core-careteam.sch) 

### Notes:

-------

**Quick Start** 

-------

Below is an overview of the required Server RESTful FHIR interactions for this profile - for example, search and read operations - when supporting the US Core interactions to access this profile's information (Profile Support + Interaction Support). Note that systems that support only US Core Profiles (Profile Only Support) are not required to support these interactions. See the [US Core Server CapabilityStatement](CapabilityStatement-us-core-server.md) for a complete list of supported RESTful interactions for this IG.

* See the [Scopes Format](scopes.md#scopes-format) section for a description of the SMART scopes syntax.
* See the [Search Syntax](general-guidance.md#search-syntax) section for a description of the US Core search syntax.
* See the [General Requirements](general-requirements.md) section for additional rules and expectations when a Server requires status parameters.
* See the [General Guidance](general-guidance.md) section for additional guidance on searching for multiple patients.

#### US Core Scopes

Servers providing access to careteam data **SHALL** support these [US Core SMART Scopes](scopes.md#smart-scopes):

* [resource level scopes](http://hl7.org/fhir/smart-app-launch/STU2.2/scopes-and-launch-context.html#scopes-for-requesting-clinical-data): `<patient|user|system>/CareTeam.rs`

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations SHALL be supported:

1. **SHALL**support searching using the combination of the**[`patient`](SearchParameter-us-core-careteam-patient.md)**and**[`status`](SearchParameter-us-core-careteam-status.md)**search parameters:
* including optional support for these `_include` parameters: `CareTeam:participant:PractitionerRole,CareTeam:participant:Practitioner,CareTeam:participant:Patient,CareTeam:participant:RelatedPerson`
* including optional support for **OR** search on `status` (e.g.`status={system|}[code],{system|}[code],...`)
`GET [base]/CareTeam?patient={Type/}[id]&status=active`Example:
1. GET [base]/CareTeam?patient=1137192&status=active
1. GET [base]/CareTeam?patient=1137192&status=active&_include=CareTeam:participant:RelatedPerson&_include=CareTeam:participant:Patient&_include=CareTeam:participant:Practitioner&_include=CareTeam:participant:PractitionerRole
**Implementation Notes:**Fetches a bundle of all CareTeam resources for the specified patient and status =`active`and may include CareTeam Patient, RelatedPerson and Practitioner and PractitionerRole participants.
To get Practitioner name and identifier using PractitionerRole:
1) Search for the careteam PractitionerRole: GET [base]/CareTeam?patient=[id]&status=active&_include=CareTeam:participant:PractitionerRole 2) Use the FHIR _id from the`PractitionerRole.practitioner`element, to fetch the Practitioner resources using GET [base]/Practitioner?_id=[id] ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the combination of the**[`patient`](SearchParameter-us-core-careteam-patient.md)**and**[`role`](SearchParameter-us-core-careteam-role.md)**search parameters:
* including optional support for these `_include` parameters: `CareTeam:participant:PractitionerRole,CareTeam:participant:Practitioner,CareTeam:participant:Patient,CareTeam:participant:RelatedPerson`
* including optional support for **OR** search on `role` (e.g.`role={system|}[code],{system|}[code],...`)
`GET [base]/CareTeam?patient={Type/}[id]&role={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/CareTeam?patient=1137192&role=http://snomed.info/sct|17561000
**Implementation Notes:**Fetches a bundle of all CareTeam resources for the specified patient and participant role ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference)and[how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "us-core-careteam",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.42.16"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreCareTeam",
  "title" : "US Core CareTeam Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-10-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "The US Core CareTeam Profile inherits from the FHIR [CareTeam](https://hl7.org/fhir/R4/careteam.html) resource; refer to it for scope and usage definitions. This profile sets minimum expectations for the CareTeam resource for identifying the Care Team members associated with a patient to promote interoperability and adoption through common implementation. It specifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource and how the elements are used. Providing the floor for standards development for specific use cases promotes interoperability and adoption.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CareTeam",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CareTeam",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CareTeam",
        "path" : "CareTeam",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CareTeam"
          }
        ]
      },
      {
        "id" : "CareTeam.status",
        "path" : "CareTeam.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Indicates whether the team is current , represents future intentions or is now a historical record.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/care-team-status"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.status"
          }
        ]
      },
      {
        "id" : "CareTeam.subject",
        "path" : "CareTeam.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.subject"
          }
        ]
      },
      {
        "id" : "CareTeam.participant",
        "path" : "CareTeam.participant",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.participant"
          }
        ]
      },
      {
        "id" : "CareTeam.participant.role",
        "path" : "CareTeam.participant.role",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Indicates specific responsibility of an individual within the care team, such as Primary physician, Team coordinator, Caregiver, etc.",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        },
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.participant.role"
          }
        ]
      },
      {
        "id" : "CareTeam.participant.member",
        "path" : "CareTeam.participant.member",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.participant.member"
          }
        ]
      }
    ]
  }
}

```
