

**Example Usage Scenarios:**

The following are example usage scenarios for the US Core ADI DocumentReference profile:

-   Query for all ADI documents belonging to a Patient
-   Query for a specific ADI Document type (e.g., POLST or Living Will)

### Mandatory and Must Support Data Elements

The following data elements must always be present ([Mandatory] definition) or must be supported if the data is present in the sending system ([Must Support] definition). They are presented below in a simple human-readable explanation. Profile specific guidance and examples are provided as well. The [Formal Views] below provides the formal summary, definitions, and terminology requirements.

**Each DocumentReference Must Have:**

1. a status
2. a code describing the type of ADI document (for example, Advance Directive for intubation)
3. an ADI document category (for example, Advance Directives)
4. a patient
5. document referenced (content)
6. the MIME type (i.e., contentType) of the document

**Each DocumentReference Must Support:**

1. a business identifier for the DocumentReference (possibly generated by the transcription system or EHR)
1. date and time the DocumentReference was created
1. an author*
2. a verifier (in other words, an authenticator)
3. a verification date
4. a code identifying the specific details about the format of the document — over and above the content's MIME type

<!-- 5. the patient encounter that is being referenced
1. clinically relevant date -->

<!-- {% raw %} {% include additional-requirements-intro.md type="DocumentReference" %}
 {% endraw %} -->

*see guidance below

**Profile Specific Implementation Guidance:**

- In addition to the [Advance Directive Categories](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.69.4/expansion) value set, other category schemes may be used to facilitate the sharing of health documents.
- The DocumentReference resources can represent the referenced content using either an address where the document can be retrieved using `DocumentReference.content.attachment.url` or the content as inline base64 encoded data using `DocumentReference.content.attachment.data`.
    -  Although both are marked as Must Support, the Server system is not required to support an address and inline base64 encoded data, but **SHALL** support at least one of these elements.
    -  The Client application **SHALL** support both elements.
    -  The `DocumentReference.content.attachment.url` may refer to a FHIR Binary Resource (i.e., [base]/Binary/[id]), FHIR Document Bundle (i.e., [base]/Bundle/[id], or another endpoint).
        - If the referenced a document or file is hosted on a server outside the FHIR server, it should be securely accessible using the same authorization credentials that were used to access the FHIR server. This reduces complexity for the client and improves the user experience.
    -  If there are multiple `DocumentReference.content` element repetitions, these **SHALL** all represent the same document in different formats or attachment metadata. The content element **SHALL NOT** contain different versions of the same content. For version handling, use multiple DocumentReferences with `DocumentReference.relatesTo`.
- Every DocumentReference must have a responsible Organization. The organization responsible for the DocumentReference **SHALL** be present either in `DocumentReference.custodian` or accessible in the Provenance resource targeting the DocumentReference using `Provenance.agent.who` or `Provenance.agent.onBehalfOf`.
   - Some systems may also expose the same organization in referenced Encounter in `Encounter.serviceProvider`.
{% include provenance-author-bullet-generator.md %}

{% include link-list.md %}
