# Whole Blood Specimen Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Whole Blood Specimen Example**

## Example Specimen: Whole Blood Specimen Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Specimen Profileversion: null8.0.1)](StructureDefinition-us-core-specimen.md)

**accessionIdentifier**: `http://acme.com/labs/accession-ids`/20220927-00126

**type**: Whole blood specimen

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

### Collections

| | |
| :--- | :--- |
| - | **Collected[x]** |
| * | 2022-09-27 18:07:12+0000 |

### Containers

| | |
| :--- | :--- |
| - | **Type** |
| * | Lavender Top Tube |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "specimen-example-whole-blood",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|8.0.1"
    ]
  },
  "accessionIdentifier" : {
    "system" : "http://acme.com/labs/accession-ids",
    "value" : "20220927-00126"
  },
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "258580003",
        "display" : "Whole blood specimen"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
        "code" : "WB",
        "display" : "Blood, Whole"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "collection" : {
    "collectedDateTime" : "2022-09-27T18:07:12Z"
  },
  "container" : [
    {
      "type" : {
        "text" : "Lavender Top Tube"
      }
    }
  ]
}

```
