# Serum Specimen Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Serum Specimen Example**

## Example Specimen: Serum Specimen Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Specimen Profileversion: null8.0.1)](StructureDefinition-us-core-specimen.md)

**accessionIdentifier**: `http://acme.com/labs/accession-ids`/20220927-00124

**type**: Serum sample

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

### Collections

| | |
| :--- | :--- |
| - | **Collected[x]** |
| * | 2022-09-27 18:07:12+0000 |

### Containers

| | |
| :--- | :--- |
| - | **Type** |
| * | Serum Separator Tube |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "specimen-example-serum",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|8.0.1"
    ]
  },
  "accessionIdentifier" : {
    "system" : "http://acme.com/labs/accession-ids",
    "value" : "20220927-00124"
  },
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "119364003",
        "display" : "Serum sample"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
        "code" : "SER",
        "display" : "Serum"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "collection" : {
    "collectedDateTime" : "2022-09-27T18:07:12Z"
  },
  "container" : [
    {
      "type" : {
        "text" : "Serum Separator Tube"
      }
    }
  ]
}

```
