# ServiceRequest for Rehab Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest for Rehab Example**

## Example ServiceRequest: ServiceRequest for Rehab Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ServiceRequest Profileversion: null8.0.1)](StructureDefinition-us-core-servicerequest.md)

**status**: Active

**intent**: Order

**category**: Social Determinants Of Health/Social Service Procedure

**code**: Alcohol rehabilitation

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**occurrence**: 2021-11-20

**authoredOn**: 2021-11-12 10:59:38-0800

**requester**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**reasonReference**: [Alcohol use disorder (disorder)](Observation-AHC-HRSN-item-example-68517-2.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "rehab",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        },
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "410606002",
          "display" : "Social service procedure"
        }
      ],
      "text" : "Social Determinants Of Health/Social Service Procedure"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "24165007",
        "display" : "Alcoholism counseling"
      },
      {
        "system" : "http://www.cms.gov/Medicare/Coding/ICD10",
        "code" : "HZ30ZZZ",
        "display" : "Individual Counseling for Substance Abuse Treatment, Cognitive"
      }
    ],
    "text" : "Alcohol rehabilitation"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "occurrenceDateTime" : "2021-11-20",
  "authoredOn" : "2021-11-12T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/practitioner-1"
  },
  "reasonReference" : [
    {
      "reference" : "Observation/AHC-HRSN-item-example-68517-2",
      "display" : "Alcohol use disorder (disorder)"
    }
  ]
}

```
