# ServiceRequest EKG Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest EKG Example**

## Example ServiceRequest: ServiceRequest EKG Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ServiceRequest Profileversion: null8.0.1)](StructureDefinition-us-core-servicerequest.md)

**status**: Active

**intent**: Order

**category**: Clinical Test Order

**code**: Cardiovascular physiologic and EKG assessment panel

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [office visit](Encounter-example-1.md)

**authoredOn**: 2024-10-13 10:59:38-0800

**requester**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**reasonCode**: Cardiac arrhythmia



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "ekg",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "386053000",
          "display" : "Evaluation procedure (procedure)"
        }
      ],
      "text" : "Clinical Test Order"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "45033-8",
        "display" : "Cardiovascular physiologic and EKG assessment panel"
      }
    ],
    "text" : "Cardiovascular physiologic and EKG assessment panel"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "office visit"
  },
  "authoredOn" : "2024-10-13T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/practitioner-1"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "698247007",
          "display" : "Cardiac arrhythmia (disorder)"
        }
      ],
      "text" : "Cardiac arrhythmia"
    }
  ]
}

```
