# USCoreEncounterIdentifier - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **USCoreEncounterIdentifier**

## SearchParameter: USCoreEncounterIdentifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreEncounterIdentifier |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.40.41 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
**Identifier(s) by which this encounter is known**
NOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the[Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation)to define additional expectations for the following SearchParameter elements: 
* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`
 
It**SHALL NOT**be used as a search parameter for search. Servers and Clients**SHOULD**use the standard FHIR SearchParameter. 

**id** us-core-encounter-identifier

**url** : **http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier** 

**name** : USCoreEncounterIdentifier

**derivedFrom** : http://hl7.org/fhir/SearchParameter/clinical-identifier

**status** : active

**date** : 11/17/2024

**publisher** : HL7 International - Cross-Group Projects

**contact** : http://www.hl7.org/Special/committees/cgp

**jurisdiction** : United States of America (the) (Details : {urn:iso:std:iso:3166 code 'US' = 'United States of America', given as 'United States of America (the)'}) 

**code** : `identifier` 

**base** :Encounter

**type** : token

**expression** : `Encounter.identifier` 

**xpath** : `f:AllergyIntolerance/f:identifier|f:CarePlan/f:identifier|f:CareTeam/f:identifier|f:Composition/f:identifier|f:Condition/f:identifier|f:Consent/f:identifier|f:DetectedIssue/f:identifier|f:DeviceRequest/f:identifier|f:DiagnosticReport/f:identifier|f:DocumentManifest/f:masterIdentifier|f:DocumentManifest/f:identifier|f:DocumentReference/f:masterIdentifier|f:DocumentReference/f:identifier|f:Encounter/f:identifier|f:EpisodeOfCare/f:identifier|f:FamilyMemberHistory/f:identifier|f:Goal/f:identifier|f:ImagingStudy/f:identifier|f:Immunization/f:identifier|f:List/f:identifier|f:MedicationAdministration/f:identifier|f:MedicationDispense/f:identifier|f:MedicationRequest/f:identifier|f:MedicationStatement/f:identifier|f:NutritionOrder/f:identifier|f:Observation/f:identifier|f:Procedure/f:identifier|f:RiskAssessment/f:identifier|f:ServiceRequest/f:identifier|f:SupplyDelivery/f:identifier|f:SupplyRequest/f:identifier|f:VisionPrescription/f:identifier` 

**xpathUsage** : normal

**multipleOr** : True (Conformance Expectation = MAY)

**multipleAnd** : True ( Conformance Expectation = MAY)



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "us-core-encounter-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier",
  "version" : "8.0.1",
  "name" : "USCoreEncounterIdentifier",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-17",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "**Identifier(s) by which this encounter is known**  \nNOTE: This SearchParameter is defined only to document Server and Client expectations. Its definition is derived from the standard FHIR SearchParameter and it uses the [Conformance expectation extension](http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation) to define additional expectations for the following SearchParameter elements:\n- `multipleAnd`\n- `multipleOr`\n- `comparator`\n- `modifier`\n- `chain`\n\nIt **SHALL NOT** be used as a search parameter for search. Servers and Clients **SHOULD** use the standard FHIR SearchParameter.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "identifier",
  "base" : ["Encounter"],
  "type" : "token",
  "expression" : "Encounter.identifier",
  "xpathUsage" : "normal",
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  }
}

```
