# Patient Niece Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Niece Example**

## Example RelatedPerson: Patient Niece Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core RelatedPerson Profileversion: null8.0.1)](StructureDefinition-us-core-relatedperson.md)

**active**: true

**patient**: [Amy V. Shaw](Patient-example.md)

**relationship**: niece

**name**: Sarah van Putten (Official)

**telecom**: ph: 555-555-5555(Home), [sarah.vanputten@example.com](mailto:sarah.vanputten@example.com)

**birthDate**: 1996-01-28

**address**: 80A VILLAGE ST NEW HOLLAND PA 17557 (home)



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "shaw-niece",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|8.0.1"
    ]
  },
  "active" : true,
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "NIECE",
          "display" : "niece"
        }
      ]
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "van Putten",
      "given" : ["Sarah"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "sarah.vanputten@example.com",
      "use" : "home"
    }
  ],
  "birthDate" : "1996-01-28",
  "address" : [
    {
      "use" : "home",
      "line" : ["80A VILLAGE ST"],
      "city" : "NEW HOLLAND",
      "state" : "PA",
      "postalCode" : "17557"
    }
  ]
}

```
