# Questionnaire PRAPARE Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire PRAPARE Example**

## Questionnaire: Questionnaire PRAPARE Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/prapare-example | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:PRAPAREExample |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.6 | |
| **Usage:**Clinical Focus: SDOH | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. Copyright © 2019. This item comes from the national PRAPARE social determinants of health assessment protocol, developed and owned by the National Association of Community Health Centers (NACHC), in partnership with the Association of Asian Pacific Community Health Organization (AAPCHO), the Oregon Primary Care Association (OPCA), and the Institute for Alternative Futures (IAF). For more information, visit www.nachc.org/prapare. Used with permission. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "prapare-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/prapare-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.6"
    }
  ],
  "version" : "8.0.1",
  "name" : "PRAPAREExample",
  "title" : "Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]",
  "status" : "active",
  "experimental" : true,
  "date" : "2023-03-31",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
            "code" : "sdoh"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. Copyright © 2019. This item comes from the national PRAPARE social determinants of health assessment protocol, developed and owned by the National Association of Community Health Centers (NACHC), in partnership with the Association of Asian Pacific Community Health Organization (AAPCHO), the Oregon Primary Care Association (OPCA), and the Institute for Alternative Futures (IAF). For more information, visit www.nachc.org/prapare. Used with permission.",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "93025-5",
      "display" : "Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]"
    }
  ],
  "item" : [
    {
      "linkId" : "/93025-5",
      "text" : "Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]",
      "type" : "group",
      "required" : false,
      "item" : [
        {
          "linkId" : "/93043-8",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "93043-8",
              "display" : "Personal characteristics [PRAPARE]"
            }
          ],
          "text" : "Personal characteristics",
          "type" : "group",
          "required" : false,
          "item" : [
            {
              "linkId" : "/93043-8/56051-6",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "56051-6",
                  "display" : "Hispanic or Latino"
                }
              ],
              "text" : "Hispanic or Latino",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93043-8/32624-9",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "32624-9",
                  "display" : "Race"
                }
              ],
              "text" : "Race",
              "type" : "choice",
              "required" : false,
              "repeats" : true,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA6156-9",
                    "display" : "Asian"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA14045-1",
                    "display" : "Native Hawaiian"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30187-1",
                    "display" : "Pacific Islander"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA14042-8",
                    "display" : "Black/African American"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA4457-3",
                    "display" : "White"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA4-4",
                    "display" : "American Indian/Alaskan Native"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA46-8",
                    "display" : "Other"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93043-8/93035-4",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93035-4",
                  "display" : "Has season or migrant farm work been your or your family's main source of income at any point in past 2 years [PRAPARE]"
                }
              ],
              "text" : "Has season or migrant farm work been your or your family's main source of income at any point in past 2 years [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93043-8/93034-7",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93034-7",
                  "display" : "Discharged from the U.S. Armed Forces"
                }
              ],
              "text" : "Discharged from the U.S. Armed Forces",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93043-8/54899-0",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "54899-0",
                  "display" : "Preferred language"
                }
              ],
              "text" : "Preferred language",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA43-5",
                    "display" : "English"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30188-9",
                    "display" : "Language other than English"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            }
          ]
        },
        {
          "linkId" : "/93042-0",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "93042-0",
              "display" : "Family and home [PRAPARE]"
            }
          ],
          "text" : "Family and home",
          "type" : "group",
          "required" : false,
          "item" : [
            {
              "linkId" : "/93042-0/63512-8",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "63512-8",
                  "display" : "How many people are living or staying at this address [#]"
                }
              ],
              "text" : "How many people are living or staying at this address [#]",
              "type" : "integer",
              "required" : false
            },
            {
              "linkId" : "/93042-0/71802-3",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "71802-3",
                  "display" : "Housing status"
                }
              ],
              "text" : "Housing status",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30189-7",
                    "display" : "I have housing"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30190-5",
                    "display" : "I do not have housing (staying with others, in a hotel, in a shelter, living outside on the street, on a beach, in a car, or in a park)"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ],
              "item" : [
                {
                  "linkId" : "/93042-0/71802-3-help",
                  "text" : "Describes patients living arrangement",
                  "type" : "display"
                }
              ]
            },
            {
              "linkId" : "/93042-0/93033-9",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93033-9",
                  "display" : "Are you worried about losing your housing [PRAPARE]"
                }
              ],
              "text" : "Are you worried about losing your housing [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93042-0/56799-0",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "56799-0",
                  "display" : "Address"
                }
              ],
              "text" : "Address",
              "type" : "string",
              "required" : false
            }
          ]
        },
        {
          "linkId" : "/93041-2",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "93041-2",
              "display" : "Money and resources [PRAPARE]"
            }
          ],
          "text" : "Money and resources",
          "type" : "group",
          "required" : false,
          "item" : [
            {
              "linkId" : "/93041-2/82589-3",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82589-3",
                  "display" : "Highest level of educ"
                }
              ],
              "text" : "Highest level of educ",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30191-3",
                    "display" : "Less than high school degree"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30192-1",
                    "display" : "High school diploma or GED"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30193-9",
                    "display" : "More than high school"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93041-2/67875-5",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "67875-5",
                  "display" : "Employment status current"
                }
              ],
              "text" : "Employment status current",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA17956-6",
                    "display" : "Unemployed"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30138-4",
                    "display" : "Part-time or temporary work"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30136-8",
                    "display" : "Full-time work"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30137-6",
                    "display" : "Otherwise unemployed but not seeking work (ex: student, retired, disabled, unpaid primary care giver)"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93041-2/76437-3",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "76437-3",
                  "display" : "Primary insurance"
                }
              ],
              "text" : "Primary insurance",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30194-7",
                    "display" : "None/uninsured"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA17849-3",
                    "display" : "Medicaid"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30195-4",
                    "display" : "CHIP Medicaid"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA15652-3",
                    "display" : "Medicare"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30196-2",
                    "display" : "Other public insurance (not CHIP)"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30197-0",
                    "display" : "Other public insurance (CHIP)"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA6350-8",
                    "display" : "Private insurance"
                  }
                }
              ]
            },
            {
              "linkId" : "/93041-2/63586-2",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "63586-2",
                  "display" : "What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]"
                }
              ],
              "text" : "What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]",
              "type" : "decimal",
              "required" : false
            },
            {
              "linkId" : "/93041-2/93031-3",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93031-3",
                  "display" : "Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]"
                }
              ],
              "text" : "Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "repeats" : true,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30125-1",
                    "display" : "Food"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30126-9",
                    "display" : "Clothing"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30124-4",
                    "display" : "Utilities"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30127-7",
                    "display" : "Child care"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30128-5",
                    "display" : "Medicine or Any Health Care (Medical, Dental, Mental Health, Vision)"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30129-3",
                    "display" : "Phone"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA46-8",
                    "display" : "Other"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93041-2/93030-5",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93030-5",
                  "display" : "Has lack of transportation kept you from medical appointments, meetings, work, or from getting things needed for daily living"
                }
              ],
              "text" : "Has lack of transportation kept you from medical appointments, meetings, work, or from getting things needed for daily living",
              "type" : "choice",
              "required" : false,
              "repeats" : true,
              "answerOption" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "A"
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30133-5",
                    "display" : "Yes, it has kept me from medical appointments or from getting my medications"
                  }
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "B"
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30134-3",
                    "display" : "Yes, it has kept me from non-medical meetings, appointments, work, or from getting things that I need"
                  }
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "C"
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "X"
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30257-2",
                    "display" : "Patient unable to respond"
                  }
                }
              ]
            }
          ]
        },
        {
          "linkId" : "/93040-4",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "93040-4",
              "display" : "Social and emotional health [PRAPARE]"
            }
          ],
          "text" : "Social and emotional health",
          "type" : "group",
          "required" : false,
          "item" : [
            {
              "linkId" : "/93040-4/93029-7",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93029-7",
                  "display" : "How often do you see or talk to people that you care about and feel close to [PRAPARE]"
                }
              ],
              "text" : "How often do you see or talk to people that you care about and feel close to [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA27722-0",
                    "display" : "Less than once a week"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30130-1",
                    "display" : "1 or 2 times a week"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30131-9",
                    "display" : "3 to 5 times a week"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30132-7",
                    "display" : "5 or more times a week"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93040-4/93038-8",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93038-8",
                  "display" : "Stress level"
                }
              ],
              "text" : "Stress is when someone feels tense, nervous, anxious or can't sleep at night because their mind is troubled. How stressed are you?",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA6568-5",
                    "display" : "Not at all"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA13863-8",
                    "display" : "A little bit"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA13909-9",
                    "display" : "Somewhat"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA13902-4",
                    "display" : "Quite a bit"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA13914-9",
                    "display" : "Very much"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            }
          ]
        },
        {
          "linkId" : "/93039-6",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "93039-6",
              "display" : "Optional additional questions [PRAPARE]"
            }
          ],
          "text" : "Optional additional questions",
          "type" : "group",
          "required" : false,
          "item" : [
            {
              "linkId" : "/93039-6/93028-9",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93028-9",
                  "display" : "Have you spent more than 2 nights in a row in a jail, prison, detention center, or juvenile correctional facility in past 1 year [PRAPARE]"
                }
              ],
              "text" : "Have you spent more than 2 nights in a row in a jail, prison, detention center, or juvenile correctional facility in past 1 year [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93039-6/93027-1",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93027-1",
                  "display" : "Are you a refugee"
                }
              ],
              "text" : "Are you a refugee",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93039-6/93026-3",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93026-3",
                  "display" : "Do you feel physically and emotionally safe where you currently live [PRAPARE]"
                }
              ],
              "text" : "Do you feel physically and emotionally safe where you currently live [PRAPARE]",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA14072-5",
                    "display" : "Unsure"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA30122-8",
                    "display" : "I choose not to answer this question"
                  }
                }
              ]
            },
            {
              "linkId" : "/93039-6/76501-6",
              "code" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "76501-6",
                  "display" : "Within the last year, have you been afraid of your partner or ex-partner"
                }
              ],
              "text" : "Within the last year, have you been afraid of your partner or ex-partner",
              "type" : "choice",
              "required" : false,
              "answerOption" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "1"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
                      "valueDecimal" : 1
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "Yes"
                  }
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
                      "valueString" : "0"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
                      "valueDecimal" : 0
                    }
                  ],
                  "valueCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA32-8",
                    "display" : "No"
                  }
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
