# Questionnaire PHQ-9 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire PHQ-9 Example**

## Questionnaire: Questionnaire PHQ-9 Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/phq-9-example | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:PHQ9Example |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.5 | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. Copyright © Pfizer Inc. All rights reserved. Developed by Drs. Robert L. Spitzer, Janet B.W. Williams, Kurt Kroenke and colleagues, with an educational grant from Pfizer Inc. No permission required to reproduce, translate, display or distribute (https://www.phqscreeners.com/). | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "phq-9-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/phq-9-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.5"
    }
  ],
  "version" : "8.0.1",
  "name" : "PHQ9Example",
  "title" : "PHQ-9 Example",
  "status" : "active",
  "experimental" : true,
  "subjectType" : ["Patient"],
  "date" : "2023-03-31",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. Copyright © Pfizer Inc. All rights reserved. Developed by Drs. Robert L. Spitzer, Janet B.W. Williams, Kurt Kroenke and colleagues, with an educational grant from Pfizer Inc. No permission required to reproduce, translate, display or distribute (https://www.phqscreeners.com/).",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "44249-1",
      "display" : "PHQ-9 quick depression assessment panel [Reported.PHQ]"
    }
  ],
  "item" : [
    {
      "linkId" : "/44250-9",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44250-9",
          "display" : "Little interest or pleasure in doing things in last 2 weeks"
        }
      ],
      "text" : "Little interest or pleasure in doing things?",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44255-8",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44255-8",
          "display" : "Feeling down, depressed, or hopeless in last 2 weeks"
        }
      ],
      "text" : "Feeling down, depressed, or hopeless?",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44259-0",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44259-0",
          "display" : "Trouble falling or staying asleep, or sleeping too much in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Trouble falling or staying asleep, or sleeping too much in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44254-1",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44254-1",
          "display" : "Feeling tired or having little energy in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Feeling tired or having little energy in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44251-7",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44251-7",
          "display" : "Poor appetite or overeating in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Poor appetite or overeating in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44258-2",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44258-2",
          "display" : "Feeling bad about yourself - or that you are a failure or have let yourself or your family down in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Feeling bad about yourself - or that you are a failure or have let yourself or your family down in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44252-5",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44252-5",
          "display" : "Trouble concentrating on things, such as reading the newspaper or watching television in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Trouble concentrating on things, such as reading the newspaper or watching television in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44253-3",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44253-3",
          "display" : "Moving or speaking so slowly that other people could have noticed. Or the opposite - being so fidgety or restless that you have been moving around a lot more than usual in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Moving or speaking so slowly that other people could have noticed. Or the opposite - being so fidgety or restless that you have been moving around a lot more than usual in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44260-8",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44260-8",
          "display" : "Thoughts that you would be better off dead, or of hurting yourself in some way in last 2 weeks [Reported.PHQ]"
        }
      ],
      "text" : "Thoughts that you would be better off dead, or of hurting yourself in some way in last 2 weeks [Reported.PHQ]",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6568-5",
            "display" : "Not at all"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6569-3",
            "display" : "Several days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6570-1",
            "display" : "More than half the days"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6571-9",
            "display" : "Nearly every day"
          }
        }
      ]
    },
    {
      "linkId" : "/44261-6",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "44261-6",
          "display" : "Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]"
        }
      ],
      "text" : "Patient health questionnaire 9 item total score",
      "type" : "decimal",
      "required" : false
    },
    {
      "linkId" : "/69722-7",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "69722-7",
          "display" : "How difficult have these made it for you to do your work, take care of things at home, or get along with other people [Reported.PHQ]"
        }
      ],
      "text" : "How difficult have these made it for you to do your work, take care of things at home, or get along with other people [Reported.PHQ]",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6572-7",
            "display" : "Not difficult at all"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6573-5",
            "display" : "Somewhat difficult"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6575-0",
            "display" : "Very difficult"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6574-3",
            "display" : "Extremely difficult"
          }
        }
      ]
    }
  ]
}

```
