# Exercise Vital Sign Questionnaire Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Exercise Vital Sign Questionnaire Example**

## Questionnaire: Exercise Vital Sign Questionnaire Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/exercise-vital-sign | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:ExerciseVitalSign |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.3 | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. This panel was reviewed and validated by Kaiser Permanente to be used to represent the Exercise Vital Sign (EVS). The EVS was developed by researchers (e.g., Coleman et al.) and is often considered part of the public domain for clinical and research use. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "exercise-vital-sign",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/exercise-vital-sign",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.3"
    }
  ],
  "version" : "8.0.1",
  "name" : "ExerciseVitalSign",
  "title" : "Exercise Vital Sign (EVS)",
  "status" : "active",
  "experimental" : true,
  "subjectType" : ["Patient"],
  "date" : "2023-08-03",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. This panel was reviewed and validated by Kaiser Permanente to be used to represent the Exercise Vital Sign (EVS). The EVS was developed by researchers (e.g., Coleman et al.) and is often considered part of the public domain for clinical and research use.",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "89574-8",
      "display" : "Exercise Vital Sign (EVS)"
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
          "valueCoding" : {
            "system" : "http://unitsofmeasure.org",
            "code" : "d/wk",
            "display" : "d/wk"
          }
        }
      ],
      "linkId" : "/89555-7",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "89555-7",
          "display" : "How many days per week did you engage in moderate to strenuous physical activity in the last 30 days"
        }
      ],
      "text" : "How many days per week did you engage in moderate to strenuous physical activity in the last 30 days?",
      "type" : "decimal",
      "required" : false
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
          "valueCoding" : {
            "system" : "http://unitsofmeasure.org",
            "code" : "min/d",
            "display" : "min/d"
          }
        }
      ],
      "linkId" : "/68516-4",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "68516-4",
          "display" : "On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise"
        }
      ],
      "text" : "On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise?",
      "type" : "decimal",
      "required" : false
    }
  ]
}

```
