# Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example**

## Questionnaire: Alcohol Use Disorder Identification Test - Consumption (AUDIT-C) Questionnaire Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/Questionnaire/AUDIT-C | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:AUDIT_C |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.35.1 | |
| **Copyright/Legal**: This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. As a WHO-approved instrument, the AUDIT is in the public domain. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "AUDIT-C",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
    ]
  },
  "url" : "http://hl7.org/fhir/us/core/Questionnaire/AUDIT-C",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.35.1"
    }
  ],
  "version" : "8.0.1",
  "name" : "AUDIT_C",
  "title" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]",
  "status" : "active",
  "experimental" : true,
  "subjectType" : ["Patient"],
  "date" : "2023-08-14",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC® (http://loinc.org). LOINC is copyright © 1995-2024, Regenstrief Institute, Inc. and the LOINC Committee, and is available at no cost under the license at http://loinc.org/license. As a WHO-approved instrument, the AUDIT is in the public domain.",
  "code" : [
    {
      "system" : "http://loinc.org",
      "code" : "72109-2",
      "display" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]"
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
          "valueCoding" : {
            "system" : "http://unitsofmeasure.org",
            "code" : "{#}/a",
            "display" : "{#}/a"
          }
        }
      ],
      "linkId" : "/68517-2",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "68517-2",
          "display" : "How many times in the past year have you have X or more drinks in a day"
        }
      ],
      "text" : "How many times in the past year have you have X or more drinks in a day",
      "type" : "decimal",
      "required" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "help",
                    "display" : "Help-Button"
                  }
                ],
                "text" : "Help-Button"
              }
            }
          ],
          "linkId" : "/68517-2-help",
          "text" : "Where X is 5 for men and 4 for women, and a response of  greater than, or equal to, 1 is positive.",
          "type" : "display"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/68519-8",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "68519-8",
          "display" : "How many standard drinks containing alcohol do you have on a typical day"
        }
      ],
      "text" : "How many standard drinks containing alcohol do you have on a typical day",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA15694-5",
            "display" : "1 or 2"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA15695-2",
            "display" : "3 or 4"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18930-0",
            "display" : "5 or 6"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18931-8",
            "display" : "7 to 9"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "4"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 4
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18932-6",
            "display" : "10 or more"
          }
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "drop-down",
                "display" : "Drop down"
              }
            ],
            "text" : "Drop down"
          }
        }
      ],
      "linkId" : "/68520-6",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "68520-6",
          "display" : "How often do you have 6 or more drinks on 1 occasion"
        }
      ],
      "text" : "How often do you have 6 or more drinks on 1 occasion",
      "type" : "choice",
      "required" : false,
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "0"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA6270-8",
            "display" : "Never"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "1"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 1
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18933-4",
            "display" : "Less than monthly"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "2"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 2
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18876-5",
            "display" : "Monthly"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "3"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 3
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18891-4",
            "display" : "Weekly"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix",
              "valueString" : "4"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 4
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA18934-2",
            "display" : "Daily or almost daily"
          }
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
          "valueCoding" : {
            "system" : "http://unitsofmeasure.org",
            "code" : "{score}",
            "display" : "{score}"
          }
        }
      ],
      "linkId" : "/75626-2",
      "code" : [
        {
          "system" : "http://loinc.org",
          "code" : "75626-2",
          "display" : "Total score [AUDIT-C]"
        }
      ],
      "text" : "Total score [AUDIT-C]",
      "type" : "decimal",
      "required" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "help",
                    "display" : "Help-Button"
                  }
                ],
                "text" : "Help-Button"
              }
            }
          ],
          "linkId" : "/75626-2-help",
          "text" : "The Alcohol Use Disorders Identification Test C (AUDIT-C) is scored on a scale of 0-12 where the higher the score, the more likely the patient's drinking is hazardous. A score of 4 or more for men and 3 or more for women is considered positive for hazardous drinking or active alcohol use disorders. If the points are all from Question 1 alone where 2 and 3 are 0, it is likely the patient is drinking below recommended limits. The care provider may review the patients alcohol intake over that past few months to confirm accuracy. [PMID: 12695273]",
          "type" : "display"
        }
      ]
    }
  ]
}

```
