# Rehab Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Rehab Example**

## Example Procedure: Rehab Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Procedure Profileversion: null8.0.1)](StructureDefinition-us-core-procedure.md)

**basedOn**: [ServiceRequest Alcoholism counseling](ServiceRequest-rehab.md)

**status**: Completed

**code**: Alcohol rehabilitation

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**performed**: 2002-05-23



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "rehab",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|8.0.1"
    ]
  },
  "basedOn" : [
    {
      "reference" : "ServiceRequest/rehab"
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "24165007",
        "display" : "Alcoholism counseling"
      },
      {
        "system" : "http://www.cms.gov/Medicare/Coding/ICD10",
        "code" : "HZ30ZZZ",
        "display" : "Individual Counseling for Substance Abuse Treatment, Cognitive"
      }
    ],
    "text" : "Alcohol rehabilitation"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "performedDateTime" : "2002-05-23"
}

```
