# Practitioner 2 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner 2 Example**

## Example Practitioner: Practitioner 2 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Practitioner Profileversion: null8.0.1)](StructureDefinition-us-core-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1245319599, `http://www.acme.org/practitioners`/456789

**name**: Fielding Kathy 

**telecom**: [Kathy.Fielding@direct.ExampleMedicalPractice.net](mailto:Kathy.Fielding@direct.ExampleMedicalPractice.net)

**address**: 1080 FIRST COLONIAL RD VIRGINIA BEACH VA 21454-2406 (work)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "practitioner-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1245319599"
    },
    {
      "system" : "http://www.acme.org/practitioners",
      "value" : "456789"
    }
  ],
  "name" : [
    {
      "family" : "Kathy",
      "given" : ["Fielding"],
      "prefix" : ["Dr"]
    }
  ],
  "telecom" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct",
          "valueBoolean" : true
        }
      ],
      "system" : "email",
      "value" : "Kathy.Fielding@direct.ExampleMedicalPractice.net",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["1080 FIRST COLONIAL RD"],
      "city" : "VIRGINIA BEACH",
      "state" : "VA",
      "postalCode" : "21454-2406"
    }
  ]
}

```
