# Practitioner 1 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner 1 Example**

## Example Practitioner: Practitioner 1 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Practitioner Profileversion: null8.0.1)](StructureDefinition-us-core-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/9941339100, `http://www.acme.org/practitioners`/25456

**name**: Ronald Bone 

**address**: 1003 HEALTHCARE DR AMHERST MA 01002 (work)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "practitioner-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9941339100"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://www.usps.com/",
                "code" : "MA"
              }
            ],
            "text" : "Massachusetts"
          }
        }
      ],
      "system" : "http://www.acme.org/practitioners",
      "value" : "25456"
    }
  ],
  "name" : [
    {
      "family" : "Bone",
      "given" : ["Ronald"],
      "prefix" : ["Dr"]
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["1003 HEALTHCARE DR"],
      "city" : "AMHERST",
      "state" : "MA",
      "postalCode" : "01002"
    }
  ]
}

```
