# Patient Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Example**

## Example Patient: Patient Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Patient Profileversion: null8.0.1)](StructureDefinition-us-core-patient.md)

Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Alt. Name: | Amy V. Shaw (Old) |
| Contact Detail | * ph: 555-555-5555(Home)
* [amy.shaw@example.com](mailto:amy.shaw@example.com)
* 49 MEADOW ST MOUNDS OK 74047 US (old)
* 183 MOUNTAIN VIEW ST MOUNDS OK 74048 US 
 |
| Language: | Spanish(preferred) |
| US Core Ethnicity Extension: | * ombCategory: [CDC Race and Ethnicity: 2135-2](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2135-2) (Hispanic or Latino)
* detailed: [CDC Race and Ethnicity: 2184-0](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2184-0) (Dominican)
* detailed: [CDC Race and Ethnicity: 2148-5](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2148-5) (Mexican)
* text: Hispanic or Latino
 |
| [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) | [SNOMED CT: 248152002](http://snomed.info/id/248152002)(Female (finding)) |
| US Core Race Extension: | * ombCategory: [CDC Race and Ethnicity: 2106-3](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2106-3) (White)
* ombCategory: [CDC Race and Ethnicity: 1002-5](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-1002-5) (American Indian or Alaska Native)
* ombCategory: [CDC Race and Ethnicity: 2028-9](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2028-9) (Asian)
* detailed: [CDC Race and Ethnicity: 1586-7](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-1586-7) (Shoshone)
* detailed: [CDC Race and Ethnicity: 2036-2](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2036-2) (Filipino)
* text: Mixed
 |
| US Core Tribal Affiliation Extension: | * tribalAffiliation: Shoshone
* isEnrolled: false
 |
| [US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md) | [SNOMED CT: 373066001](http://snomed.info/id/373066001)(Yes (qualifier value)) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|8.0.1"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2106-3",
            "display" : "White"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1586-7",
            "display" : "Shoshone"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2036-2",
            "display" : "Filipino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Mixed"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2135-2",
            "display" : "Hispanic or Latino"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2184-0",
            "display" : "Dominican"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2148-5",
            "display" : "Mexican"
          }
        },
        {
          "url" : "text",
          "valueString" : "Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "extension" : [
        {
          "url" : "tribalAffiliation",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS",
                "code" : "187",
                "display" : "Paiute-Shoshone Tribe of the Fallon Reservation and Colony, Nevada"
              }
            ],
            "text" : "Shoshone"
          }
        },
        {
          "url" : "isEnrolled",
          "valueBoolean" : false
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation"
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-individual-sex",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "248152002",
        "display" : "Female (finding)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-interpreter-needed",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "373066001"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org/patient/identifiers",
      "value" : "1032702"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "old",
      "family" : "Shaw",
      "given" : ["Amy", "V."],
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "use" : "usual",
      "family" : "Baxter",
      "given" : ["Amy", "V."],
      "suffix" : ["PharmD"],
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "amy.shaw@example.com"
    }
  ],
  "birthDate" : "1987-02-20",
  "address" : [
    {
      "use" : "old",
      "line" : ["49 MEADOW ST"],
      "city" : "MOUNDS",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "line" : ["183 MOUNTAIN VIEW ST"],
      "city" : "MOUNDS",
      "state" : "OK",
      "postalCode" : "74048",
      "country" : "US",
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "es",
            "display" : "Spanish"
          }
        ]
      },
      "preferred" : true
    }
  ]
}

```
