# Deceased Patient Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Deceased Patient Example**

## Example Patient: Deceased Patient Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Patient Profileversion: null8.0.1)](StructureDefinition-us-core-patient.md)

Mary A. Shaw (no stated gender), DoB: 1937-10-21 ( Medical Record Number: 55555555 (use: usual, ))

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Deceased: | 2022-07-22 |
| Contact Detail | * ph: 555-555-5555(Home)
* [mary.shaw@example.com](mailto:mary.shaw@example.com)
* 49 MEADOW ST MOUNDS OK 74047 US 
 | | |
| US Core Ethnicity Extension: | * ombCategory: [CDC Race and Ethnicity: 2186-5](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2186-5) (Not Hispanic or Latino)
* text: Not Hispanic or Latino
 | | |
| [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) | [SNOMED CT: 248152002](http://snomed.info/id/248152002)(Female (finding)) | | |
| US Core Race Extension: | * ombCategory: [CDC Race and Ethnicity: 2106-3](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2106-3) (White)
* ombCategory: [CDC Race and Ethnicity: 2028-9](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2028-9) (Asian)
* text: Mixed
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "deceased-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|8.0.1"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2106-3",
            "display" : "White"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "text",
          "valueString" : "Mixed"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2186-5",
            "display" : "Not Hispanic or Latino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Not Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-individual-sex",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "248152002",
        "display" : "Female (finding)"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org/patient/identifiers",
      "value" : "55555555"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Shaw",
      "given" : ["Mary", "A."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "mary.shaw@example.com"
    }
  ],
  "birthDate" : "1937-10-21",
  "deceasedDateTime" : "2022-07-22",
  "address" : [
    {
      "line" : ["49 MEADOW ST"],
      "city" : "MOUNDS",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06"
      }
    }
  ]
}

```
