# Patient Child Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Child Example**

## Example Patient: Patient Child Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Patient Profileversion: null8.0.1)](StructureDefinition-us-core-patient.md)

Child Example (no stated gender), DoB: 2016-01-15 ( Medical Record Number: 1032704 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Contact Detail | * ph: 555-555-5555(Home)
* 49 MEADOW ST MOUNDS OK 74047 US 
 |
| US Core Ethnicity Extension: | * ombCategory: [CDC Race and Ethnicity: 2186-5](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2186-5) (Not Hispanic or Latino)
* text: Not Hispanic or Latino
 |
| [US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) | [SNOMED CT: 248153007](http://snomed.info/id/248153007)(Male (finding)) |
| US Core Race Extension: | * ombCategory: [CDC Race and Ethnicity: 2028-9](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html#CDCREC-2028-9) (Asian)
* text: Asian
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "child-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|8.0.1"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "text",
          "valueString" : "Asian"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2186-5",
            "display" : "Not Hispanic or Latino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Not Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-individual-sex",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "248153007",
        "display" : "Male (finding)"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org/patient/identifiers",
      "value" : "1032704"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Example",
      "given" : ["Child"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    }
  ],
  "birthDate" : "2016-01-15",
  "address" : [
    {
      "line" : ["49 MEADOW ST"],
      "city" : "MOUNDS",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US"
    }
  ]
}

```
