# Saint Luke W Endpoint Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Saint Luke W Endpoint Example**

## Example Organization: Saint Luke W Endpoint Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

# Organization

ID: 393872

Name: Saint Luke's Hospital of Kansas City 

NPI: 1063494177

Phone:(816)932-2000

Address:4401 Wornall Rd,, MO, 64111



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "saint-luke-w-endpoint",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|8.0.1"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Endpoint",
      "id" : "75",
      "status" : "active",
      "connectionType" : {
        "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
        "code" : "direct-project"
      },
      "name" : "Dr. Ronald Bone Direct Address",
      "managingOrganization" : {
        "reference" : "Organization/example-organization-2"
      },
      "payloadType" : [
        {
          "coding" : [
            {
              "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
              "code" : "urn:hl7-org:sdwg:ccda-structuredBody:1.1"
            }
          ]
        }
      ],
      "payloadMimeType" : ["text/xml"],
      "address" : "mailto:Interoperability@DirectAddress.com"
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1063494177"
    },
    {
      "system" : "http://example.org/fhir/us/argo/sid/us-ein",
      "value" : "00-0000000"
    }
  ],
  "active" : true,
  "name" : "Saint Luke's Hospital of Kansas City",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(816)932-2000",
      "use" : "work"
    },
    {
      "system" : "other",
      "value" : "http://www.saintlukeshealthsystem.org/locations/saint-lukes-hospital-kansas-city",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "text" : "4401 WORNALL RD AMHERST MA 01002",
      "line" : ["4401 WORNALL RD"],
      "city" : "AMHERST",
      "state" : "MA",
      "postalCode" : "64111"
    }
  ],
  "endpoint" : [
    {
      "reference" : "#75"
    }
  ]
}

```
