# Xray Chest Impression Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xray Chest Impression Example**

## Example Observation: Xray Chest Impression Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Imaging

**code**: Impression

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: ER Visit

**effective**: 2019-02-03 19:43:30+0000

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: No acute abnormality



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "xray-chest-impression",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging",
          "display" : "Imaging"
        }
      ],
      "text" : "Imaging"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "19005-8",
        "display" : "Radiology Imaging study [Impression] (narrative)"
      }
    ],
    "text" : "Impression"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "ER Visit"
  },
  "effectiveDateTime" : "2019-02-03T19:43:30+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueString" : "No acute abnormality"
}

```
