# Treatment Intervention Preference Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Treatment Intervention Preference Example**

## Example Observation: Treatment Intervention Preference Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Treatment Intervention Preference Profileversion: null8.0.1)](StructureDefinition-us-core-treatment-intervention-preference.md)

**status**: Final

**category**: Treatment Intervention Preference

**code**: preferences for medical treatment

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-30

**performer**: [Amy Shaw](Patient-example.md)

**value**: If I am having significant pain or suffering, I would like my doctors to consult a Supportive and Palliative Care Team to help treat my physical, emotional and spiritual discomfort, and to support my family.



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "treatment-intervention-preference",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-treatment-intervention-preference|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "treatment-intervention-preference",
          "display" : "Treatment Intervention preference"
        }
      ],
      "text" : "Treatment Intervention Preference"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "75773-2",
        "display" : "Goals, preferences, and priorities for medical treatment Narrative - Reported"
      }
    ],
    "text" : "preferences for medical treatment"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-30",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueString" : "If I am having significant pain or suffering, I would like my doctors to consult a Supportive and Palliative Care Team to help treat my physical, emotional and spiritual discomfort, and to support my family."
}

```
