# Substance Use Status Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance Use Status Example**

## Example Observation: Substance Use Status Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**identifier**: `http://example.org/fhir/Observation/identifiers`/19a199c7-8fdf-11ec-9837-020000000000

**status**: Final

**category**: Social History

**code**: Substance use status

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03

**performer**: [Amy Shaw](Patient-example.md)

**value**: true

**note**: 

> 

At parties


> **component****code**:Drug or medicament**value**:Amphetamine

> **component****code**:Frequency of drug misuse**value**: 3 times a year



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "substance-use-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/fhir/Observation/identifiers",
      "value" : "19a199c7-8fdf-11ec-9837-020000000000"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "228366006",
        "display" : "Finding relating to drug misuse behavior (finding)"
      }
    ],
    "text" : "Substance use status"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-03",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueBoolean" : true,
  "note" : [
    {
      "text" : "At parties"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/731000124108",
            "code" : "410942007",
            "display" : "Drug or medicament (substance)"
          }
        ],
        "text" : "Drug or medicament"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/731000124108",
            "code" : "703842006",
            "display" : "Amphetamine"
          }
        ],
        "text" : "Amphetamine"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/731000124108",
            "code" : "228390007",
            "display" : "Frequency of drug misuse (observable entity)"
          }
        ],
        "text" : "Frequency of drug misuse"
      },
      "valueString" : "3 times a year"
    }
  ]
}

```
