# Some Day Smoker Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Some Day Smoker Example**

## Example Observation: Some Day Smoker Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Smoking Status Observation Profileversion: null8.0.1)](StructureDefinition-us-core-smokingstatus.md)

**status**: Final

**category**: Social History

**code**: Tobacco smoking status

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2016-03-18 05:27:04+0000 --> (ongoing)

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: Current some day smoker



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "some-day-smoker",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72166-2",
        "display" : "Tobacco smoking status"
      }
    ],
    "text" : "Tobacco smoking status"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectivePeriod" : {
    "start" : "2016-03-18T05:27:04+00:00"
  },
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "428041000124106"
      }
    ],
    "text" : "Current some day smoker"
  }
}

```
