# Simple Observation Functional Status Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Simple Observation Functional Status Example**

## Example Observation: Simple Observation Functional Status Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Functional Status

**code**: Functional status [Interpretation]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-11-24 21:26:59+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: Independent with dressing (finding)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "simple-observation-functional-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "functional-status",
          "display" : "Functional Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "75276-6",
        "display" : "Functional status [Interpretation]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-11-24T21:26:59Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "129035000",
        "display" : "Independent with dressing (finding)"
      }
    ]
  }
}

```
