# Simple Observation Cognitive Status Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Simple Observation Cognitive Status Example**

## Example Observation: Simple Observation Cognitive Status Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Cognitive Status

**code**: History of Cognitive Function Narrative

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-11-27 19:22:02+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: Alert and oriented x 3. She is independent in household finances, social and community activities, coherent and appropriate communication. Appropriate attire for location and weather.



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "simple-observation-cognitive-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "cognitive-status",
          "display" : "Cognitive Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11332-4",
        "display" : "History of Cognitive Function Narrative"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-11-27T19:22:02Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueString" : "Alert and oriented x 3. She is independent in household finances, social and community activities, coherent and appropriate communication. Appropriate attire for location and weather."
}

```
