# Serum CO2 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Serum CO2 Example**

## Example Observation: Serum CO2 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-05 15:29:58+0000

Profile: [US Core Laboratory Result Observation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-lab.md)

**status**: Final

**category**: Laboratory

**code**: Carbon Dioxide (CO2), Blood

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2005-07-05

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 24 mmol/L(Details: UCUM codemmol/L = 'mmol/L')

**interpretation**: Normal

**specimen**: [Serum specimen](Specimen-specimen-example-serum.md)

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 22 mmol/L(Details: UCUM codemmol/L = 'mmol/L') | 29 mmol/L(Details: UCUM codemmol/L = 'mmol/L') | Normal Range |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "serum-co2",
  "meta" : {
    "lastUpdated" : "2005-07-05T15:29:58.597000+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "2028-9",
        "display" : "CO2 SerPl-sCnc"
      }
    ],
    "text" : "Carbon Dioxide (CO2), Blood"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2005-07-05",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 24,
    "unit" : "mmol/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mmol/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ],
      "text" : "Normal"
    }
  ],
  "specimen" : {
    "reference" : "Specimen/specimen-example-serum",
    "display" : "Serum specimen"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 22,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "high" : {
        "value" : 29,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
            "code" : "normal",
            "display" : "Normal Range"
          }
        ],
        "text" : "Normal Range"
      }
    }
  ]
}

```
