# Pregnancy Intent Observation Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pregnancy Intent Observation Example**

## Example Observation: Pregnancy Intent Observation Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Pregnancy Intent Profileversion: null8.0.1)](StructureDefinition-us-core-observation-pregnancyintent.md)

**status**: Final

**category**: Social History

**code**: Pregnancy Intent

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2022-09-23 22:39:43+0000

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: Pregnant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pregnancy-intent",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "86645-9",
        "display" : "Pregnancy intention in the next year - Reported"
      }
    ],
    "text" : "Pregnancy Intent"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2022-09-23T22:39:43+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "454381000124105",
        "display" : "Not sure of desire to become pregnant (finding)"
      }
    ],
    "text" : "Pregnant"
  }
}

```
