# Pediatric Wt Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pediatric Wt Example**

## Example Observation: Pediatric Wt Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Pediatric Weight for Height Observation Profileversion: null8.0.1)](StructureDefinition-pediatric-weight-for-height.md)

**status**: Final

**category**: Vital Signs

**code**: BMI

**subject**: [Infant Example](Patient-infant-example.md)

**encounter**: GP Visit

**effective**: 2020-07-02

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 65 %(Details: UCUM code% = '%')

**note**: 

> 

WHO Males, 0-2 years Chart




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pediatric-wt-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "77606-2",
        "display" : "Weight-for-length Per age and sex"
      }
    ],
    "text" : "BMI"
  },
  "subject" : {
    "reference" : "Patient/infant-example",
    "display" : "Infant Example"
  },
  "encounter" : {
    "display" : "GP Visit"
  },
  "effectiveDateTime" : "2020-07-02",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 65,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "note" : [
    {
      "text" : "WHO Males, 0-2 years Chart"
    }
  ]
}

```
