# Cigarette Pack-Years Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cigarette Pack-Years Example**

## Example Observation: Cigarette Pack-Years Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Smoking Status Observation Profileversion: null8.0.1)](StructureDefinition-us-core-smokingstatus.md)

**status**: Final

**category**: Social History

**code**: Cigarette pack-years

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2016-03-18 05:27:04+0000

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 26 pack-years(Details: UCUM code{pack-years} = '{pack-years}')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pack-years-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "401201003",
        "display" : "Cigarette pack-years (observable entity)"
      }
    ],
    "text" : "Cigarette pack-years"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2016-03-18T05:27:04+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 26,
    "unit" : "pack-years",
    "system" : "http://unitsofmeasure.org",
    "code" : "{pack-years}"
  }
}

```
