# P-R interval {EKG lead} Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P-R interval {EKG lead} Example**

## Example Observation: P-R interval {EKG lead} Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Procedure

**code**: P-R interval {EKG lead}

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: Cardiology Consult

**effective**: 2021-11-10 16:48:57-0800

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 0.2 s(Details: UCUM codes = 's')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "p-r-interval-ekg-lead",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "procedure",
          "display" : "Procedure"
        }
      ],
      "text" : "Procedure"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "44976-9",
        "display" : "P-R interval {EKG lead}"
      }
    ],
    "text" : "P-R interval {EKG lead}"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "Cardiology Consult"
  },
  "effectiveDateTime" : "2021-11-10T16:48:57.246958-08:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 0.2,
    "unit" : "s",
    "system" : "http://unitsofmeasure.org",
    "code" : "s"
  }
}

```
