# OFC Percentile Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **OFC Percentile Example**

## Example Observation: OFC Percentile Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Pediatric Head Occipital Frontal Circumference Percentile Profileversion: null8.0.1)](StructureDefinition-head-occipital-frontal-circumference-percentile.md)

**status**: Final

**category**: Vital Signs

**code**: Head Occipital-frontal circumference Percentile

**subject**: [Infant Example](Patient-infant-example.md)

**effective**: 2020-07-01

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 82 %(Details: UCUM code% = '%')

**note**: 

> 

WHO Males, 0-2 years Chart




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ofc-percentile",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8289-1",
        "display" : "Head Occipital-frontal circumference Percentile"
      }
    ],
    "text" : "Head Occipital-frontal circumference Percentile"
  },
  "subject" : {
    "reference" : "Patient/infant-example",
    "display" : "Infant Example"
  },
  "effectiveDateTime" : "2020-07-01",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 82,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "note" : [
    {
      "text" : "WHO Males, 0-2 years Chart"
    }
  ]
}

```
