# Occupation Observation Example: Industry Unknown - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Occupation Observation Example: Industry Unknown**

## Example Observation: Occupation Observation Example: Industry Unknown

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Occupation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-occupation.md)

**status**: Final

**category**: Social History

**code**: History of Occupation

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-04-10 --> (ongoing)

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: Certified Nursing Assistant (CNA) [Nursing Assistants]



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-occupation-industry-unknown",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11341-5",
        "display" : "History of Occupation"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectivePeriod" : {
    "start" : "2022-04-10"
  },
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH",
        "code" : "31-1014.00.007136",
        "display" : "Certified Nursing Assistant (CNA) [Nursing Assistants]"
      }
    ]
  }
}

```
