# Head Circumference Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Head Circumference Example**

## Example Observation: Head Circumference Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Head Circumference Profileversion: null8.0.1)](StructureDefinition-us-core-head-circumference.md)

**status**: Final

**category**: Vital Signs

**code**: Head Circumference

**subject**: [Infant Example (no stated gender), DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))](Patient-infant-example.md)

**effective**: 2020-11-18 16:19:31-0800

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 51.2 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "head-circumference",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "9843-4",
        "display" : "Head Occipital-frontal circumference"
      }
    ],
    "text" : "Head Circumference"
  },
  "subject" : {
    "reference" : "Patient/infant-example"
  },
  "effectiveDateTime" : "2020-11-18T16:19:31-08:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 51.2,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
