# Exercise Per Day Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Exercise Per Day Example**

## Example Observation: Exercise Per Day Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Social History, Physical Activity

**code**: Exercise Minutes Per Day

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03

**performer**: [Amy Shaw](Patient-example.md)

**value**: 60 minutes per day(Details: UCUM codemin/d = 'min/d')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "exercise-per-day",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "activity",
          "display" : "Activity"
        }
      ],
      "text" : "Physical Activity"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "68516-4",
        "display" : "On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise"
      }
    ],
    "text" : "Exercise Minutes Per Day"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-03",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueQuantity" : {
    "value" : 60,
    "unit" : "minutes per day",
    "system" : "http://unitsofmeasure.org",
    "code" : "min/d"
  }
}

```
