# DXA Femur-L T-score BMD Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DXA Femur-L T-score BMD Example**

## Example Observation: DXA Femur-L T-score BMD Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Imaging

**code**: DXA Femur-L T-score BMD

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: Bone Scan

**effective**: 2021-11-10 19:14:41-0800

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: -1.48 T-Score(Details: UCUM code1 = '1')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "dxa-femur-l-t-score-bmd",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging",
          "display" : "Imaging"
        }
      ],
      "text" : "Imaging"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "80948-3",
        "display" : "DXA Femur-L T-score BMD"
      }
    ],
    "text" : "DXA Femur-L T-score BMD"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "Bone Scan"
  },
  "effectiveDateTime" : "2021-11-10T19:14:41.088720-08:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : -1.48,
    "unit" : "T-Score",
    "system" : "http://unitsofmeasure.org",
    "code" : "1"
  }
}

```
